"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ProfilingFlamegraph = ProfilingFlamegraph;
var _eui = require("@elastic/eui");
var _react = _interopRequireDefault(require("react"));
var _use_fetcher = require("../../../../hooks/use_fetcher");
var _use_time_range = require("../../../../hooks/use_time_range");
var _flamegraph = require("../../charts/flamegraph");
var _flamegraph_link = require("./flamegraph_link");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1762971603108095020/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/observability/plugins/apm/public/components/shared/profiling/flamegraph/index.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function ProfilingFlamegraph({
  serviceName,
  rangeFrom,
  rangeTo,
  kuery,
  transactionName,
  transactionType,
  environment
}) {
  const {
    start,
    end
  } = (0, _use_time_range.useTimeRange)({
    rangeFrom,
    rangeTo
  });
  const {
    data,
    status
  } = (0, _use_fetcher.useFetcher)(callApmApi => {
    if (!transactionType) {
      return;
    }
    return callApmApi('GET /internal/apm/services/{serviceName}/profiling/flamegraph', {
      params: {
        path: {
          serviceName
        },
        query: {
          start,
          end,
          kuery,
          transactionName,
          transactionType,
          environment
        }
      }
    });
  }, [serviceName, start, end, kuery, transactionName, transactionType, environment]);
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_flamegraph_link.ProfilingFlamegraphLink, {
    kuery: kuery,
    rangeFrom: rangeFrom,
    rangeTo: rangeTo,
    justifyContent: "flexEnd",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 59,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 65,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(_flamegraph.FlamegraphChart, {
    data: data,
    status: status,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 66,
      columnNumber: 7
    }
  }));
}