"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ServiceDashboards = ServiceDashboards;
var _react = _interopRequireWildcard(require("react"));
var _i18n = require("@kbn/i18n");
var _eui = require("@elastic/eui");
var _public = require("@kbn/dashboard-plugin/public");
var _empty_dashboards = require("./empty_dashboards");
var _actions = require("./actions");
var _use_fetcher = require("../../../hooks/use_fetcher");
var _use_apm_params = require("../../../hooks/use_apm_params");
var _context_menu = require("./context_menu");
var _unlink_dashboard = require("./actions/unlink_dashboard");
var _edit_dashboard = require("./actions/edit_dashboard");
var _dashboard_selector = require("./dashboard_selector");
var _use_adhoc_apm_data_view = require("../../../hooks/use_adhoc_apm_data_view");
var _static_dashboard = require("../metrics/static_dashboard");
var _use_dashboards_fetcher = require("../../../hooks/use_dashboards_fetcher");
var _use_time_range = require("../../../hooks/use_time_range");
var _service_detail_locator = require("../../../locator/service_detail_locator");
var _use_apm_plugin_context = require("../../../context/apm_plugin/use_apm_plugin_context");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1762971603108095020/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/observability/plugins/apm/public/components/app/service_dashboards/index.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
function ServiceDashboards() {
  const {
    path: {
      serviceName
    },
    query: {
      environment,
      kuery,
      rangeFrom,
      rangeTo,
      dashboardId
    }
  } = (0, _use_apm_params.useAnyOfApmParams)('/services/{serviceName}/dashboards', '/mobile-services/{serviceName}/dashboards');
  const [dashboard, setDashboard] = (0, _react.useState)();
  const [serviceDashboards, setServiceDashboards] = (0, _react.useState)([]);
  const [currentDashboard, setCurrentDashboard] = (0, _react.useState)();
  const {
    data: allAvailableDashboards
  } = (0, _use_dashboards_fetcher.useDashboardFetcher)();
  const {
    start,
    end
  } = (0, _use_time_range.useTimeRange)({
    rangeFrom,
    rangeTo
  });
  const {
    dataView
  } = (0, _use_adhoc_apm_data_view.useAdHocApmDataView)();
  const {
    share
  } = (0, _use_apm_plugin_context.useApmPluginContext)();
  const {
    data,
    status,
    refetch
  } = (0, _use_fetcher.useFetcher)(callApmApi => {
    if (serviceName) {
      return callApmApi(`GET /internal/apm/services/{serviceName}/dashboards`, {
        isCachable: false,
        params: {
          path: {
            serviceName
          },
          query: {
            start,
            end
          }
        }
      });
    }
  }, [serviceName, start, end]);
  (0, _react.useEffect)(() => {
    var _data$serviceDashboar;
    const filteredServiceDashboards = ((_data$serviceDashboar = data === null || data === void 0 ? void 0 : data.serviceDashboards) !== null && _data$serviceDashboar !== void 0 ? _data$serviceDashboar : []).reduce((result, serviceDashboard) => {
      const matchedDashboard = allAvailableDashboards.find(({
        id
      }) => id === serviceDashboard.dashboardSavedObjectId);
      if (matchedDashboard) {
        result.push({
          title: matchedDashboard.attributes.title,
          ...serviceDashboard
        });
      }
      return result;
    }, []);
    setServiceDashboards(filteredServiceDashboards);
  }, [allAvailableDashboards, data]);
  const getCreationOptions = (0, _react.useCallback)(() => {
    const getInitialInput = () => ({
      viewMode: 'view',
      timeRange: {
        from: rangeFrom,
        to: rangeTo
      }
    });
    return Promise.resolve({
      getInitialInput
    });
  }, [rangeFrom, rangeTo]);
  (0, _react.useEffect)(() => {
    if (!dashboard) return;
    dashboard.setFilters(dataView && currentDashboard !== null && currentDashboard !== void 0 && currentDashboard.serviceEnvironmentFilterEnabled && currentDashboard !== null && currentDashboard !== void 0 && currentDashboard.serviceNameFilterEnabled ? (0, _static_dashboard.getFilters)(serviceName, environment, dataView) : []);
    dashboard.setQuery({
      query: kuery,
      language: 'kuery'
    });
    dashboard.setTimeRange({
      from: rangeFrom,
      to: rangeTo
    });
  }, [dataView, serviceName, environment, kuery, dashboard, rangeFrom, rangeTo, currentDashboard]);
  const getLocatorParams = (0, _react.useCallback)(params => {
    return {
      serviceName,
      dashboardId: params.dashboardId,
      query: {
        environment,
        kuery,
        rangeFrom,
        rangeTo
      }
    };
  }, [serviceName, environment, kuery, rangeFrom, rangeTo]);
  const locator = (0, _react.useMemo)(() => {
    const baseLocator = share.url.locators.get(_service_detail_locator.APM_APP_LOCATOR_ID);
    if (!baseLocator) return;
    return {
      ...baseLocator,
      getRedirectUrl: params => baseLocator.getRedirectUrl(getLocatorParams(params)),
      navigate: params => baseLocator.navigate(getLocatorParams(params))
    };
  }, [share, getLocatorParams]);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
    hasBorder: true,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 149,
      columnNumber: 5
    }
  }, status === _use_fetcher.FETCH_STATUS.LOADING ? /*#__PURE__*/_react.default.createElement(_eui.EuiEmptyPrompt, {
    icon: /*#__PURE__*/_react.default.createElement(_eui.EuiLoadingLogo, {
      logo: "logoObservability",
      size: "xl",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 152,
        columnNumber: 17
      }
    }),
    title: /*#__PURE__*/_react.default.createElement("h4", {
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 154,
        columnNumber: 13
      }
    }, _i18n.i18n.translate('xpack.apm.serviceDashboards.loadingServiceDashboards', {
      defaultMessage: 'Loading service dashboard'
    })),
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 151,
      columnNumber: 9
    }
  }) : status === _use_fetcher.FETCH_STATUS.SUCCESS && (serviceDashboards === null || serviceDashboards === void 0 ? void 0 : serviceDashboards.length) > 0 ? /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    justifyContent: "spaceBetween",
    gutterSize: "xs",
    alignItems: "center",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 163,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: true,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 164,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "s",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 165,
      columnNumber: 15
    }
  }, /*#__PURE__*/_react.default.createElement("h3", {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 166,
      columnNumber: 17
    }
  }, currentDashboard === null || currentDashboard === void 0 ? void 0 : currentDashboard.title))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 170,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_dashboard_selector.DashboardSelector, {
    currentDashboardId: dashboardId,
    serviceDashboards: serviceDashboards,
    setCurrentDashboard: setCurrentDashboard,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 171,
      columnNumber: 15
    }
  })), currentDashboard && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 179,
      columnNumber: 15
    }
  }, /*#__PURE__*/_react.default.createElement(_context_menu.ContextMenu, {
    items: [/*#__PURE__*/_react.default.createElement(_actions.LinkDashboard, {
      emptyButton: true,
      onRefresh: refetch,
      serviceDashboards: serviceDashboards,
      serviceName: serviceName,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 182,
        columnNumber: 21
      }
    }), /*#__PURE__*/_react.default.createElement(_actions.GotoDashboard, {
      currentDashboard: currentDashboard,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 188,
        columnNumber: 21
      }
    }), /*#__PURE__*/_react.default.createElement(_edit_dashboard.EditDashboard, {
      currentDashboard: currentDashboard,
      onRefresh: refetch,
      serviceName: serviceName,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 189,
        columnNumber: 21
      }
    }), /*#__PURE__*/_react.default.createElement(_unlink_dashboard.UnlinkDashboard, {
      currentDashboard: currentDashboard,
      defaultDashboard: serviceDashboards[0],
      onRefresh: refetch,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 194,
        columnNumber: 21
      }
    })],
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 180,
      columnNumber: 17
    }
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: true,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 204,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "l",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 205,
      columnNumber: 13
    }
  }), dashboardId && /*#__PURE__*/_react.default.createElement(_public.DashboardRenderer, {
    locator: locator,
    savedObjectId: dashboardId,
    getCreationOptions: getCreationOptions,
    onApiAvailable: setDashboard,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 207,
      columnNumber: 15
    }
  }))) : /*#__PURE__*/_react.default.createElement(_empty_dashboards.EmptyDashboards, {
    actions: /*#__PURE__*/_react.default.createElement(_actions.LinkDashboard, {
      onRefresh: refetch,
      serviceName: serviceName,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 218,
        columnNumber: 20
      }
    }),
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 217,
      columnNumber: 9
    }
  }));
}