"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.setFlappingHistoryAndTrackedAlerts = setFlappingHistoryAndTrackedAlerts;
exports.updateAlertFlappingHistory = updateAlertFlappingHistory;
var _lodash = require("lodash");
var _flapping_utils = require("./flapping_utils");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function setFlappingHistoryAndTrackedAlerts(flappingSettings, newAlerts = {}, activeAlerts = {}, recoveredAlerts = {}, previouslyRecoveredAlerts = {}) {
  const trackedActiveAlerts = {};
  const trackedRecoveredAlerts = {};
  const previouslyRecoveredAlertIds = new Set(Object.keys(previouslyRecoveredAlerts));
  for (const id of (0, _lodash.keys)(activeAlerts)) {
    const alert = activeAlerts[id];
    trackedActiveAlerts[id] = alert;
    // this alert was not active in the previous run
    if (newAlerts[id]) {
      if (previouslyRecoveredAlertIds.has(id)) {
        // this alert has flapped from recovered to active
        const previousFlappingHistory = previouslyRecoveredAlerts[id].getFlappingHistory();
        alert.setFlappingHistory(previousFlappingHistory);
        previouslyRecoveredAlertIds.delete(id);
      }
      updateAlertFlappingHistory(flappingSettings, newAlerts[id], true);
    } else {
      // this alert is still active
      updateAlertFlappingHistory(flappingSettings, alert, false);
    }
  }
  for (const id of (0, _lodash.keys)(recoveredAlerts)) {
    const alert = recoveredAlerts[id];
    trackedRecoveredAlerts[id] = alert;
    // this alert has flapped from active to recovered
    updateAlertFlappingHistory(flappingSettings, alert, true);
  }
  for (const id of previouslyRecoveredAlertIds) {
    const alert = previouslyRecoveredAlerts[id];
    trackedRecoveredAlerts[id] = alert;
    // this alert is still recovered
    updateAlertFlappingHistory(flappingSettings, alert, false);
  }
  return {
    newAlerts,
    activeAlerts,
    trackedActiveAlerts,
    recoveredAlerts,
    trackedRecoveredAlerts
  };
}
function updateAlertFlappingHistory(flappingSettings, alert, state) {
  const updatedFlappingHistory = (0, _flapping_utils.updateFlappingHistory)(flappingSettings, alert.getFlappingHistory() || [], state);
  alert.setFlappingHistory(updatedFlappingHistory);
}