"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.initComponent = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _lodash = require("lodash");
var _react = _interopRequireDefault(require("react"));
var _common = require("@kbn/field-formats-plugin/common");
var _i18nReact = require("@kbn/i18n-react");
var _eui = require("@elastic/eui");
var _fastDeepEqual = _interopRequireDefault(require("fast-deep-equal"));
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1762971603108095020/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/aiops/public/cases/log_pattern_attachment.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const initComponent = exports.initComponent = (0, _lodash.memoize)((fieldFormats, PatternAnalysisComponent) => {
  return /*#__PURE__*/_react.default.memo(props => {
    const {
      persistableStateAttachmentState
    } = props;
    const dataFormatter = fieldFormats.deserialize({
      id: _common.FIELD_FORMAT_IDS.DATE
    });
    const inputProps = persistableStateAttachmentState;
    const listItems = [{
      title: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.aiops.logPatternAnalysis.cases.timeRangeLabel",
        defaultMessage: "Time range",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 36,
          columnNumber: 15
        }
      }),
      description: `${dataFormatter.convert(inputProps.timeRange.from)} - ${dataFormatter.convert(inputProps.timeRange.to)}`
    }];
    return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiDescriptionList, {
      compressed: true,
      type: 'inline',
      listItems: listItems,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 49,
        columnNumber: 13
      }
    }), /*#__PURE__*/_react.default.createElement(PatternAnalysisComponent, (0, _extends2.default)({}, inputProps, {
      embeddingOrigin: 'cases',
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 50,
        columnNumber: 13
      }
    })));
  }, (prevProps, nextProps) => (0, _fastDeepEqual.default)(prevProps.persistableStateAttachmentState, nextProps.persistableStateAttachmentState));
});