/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.esql.optimizer;

import org.elasticsearch.xpack.esql.capabilities.PostPhysicalOptimizationVerificationAware;
import org.elasticsearch.xpack.esql.common.Failure;
import org.elasticsearch.xpack.esql.common.Failures;
import org.elasticsearch.xpack.esql.core.expression.Attribute;
import org.elasticsearch.xpack.esql.core.expression.Expressions;
import org.elasticsearch.xpack.esql.optimizer.PostOptimizationPhasePlanVerifier;
import org.elasticsearch.xpack.esql.optimizer.rules.PlanConsistencyChecker;
import org.elasticsearch.xpack.esql.plan.logical.ExecutesOn;
import org.elasticsearch.xpack.esql.plan.physical.FieldExtractExec;
import org.elasticsearch.xpack.esql.plan.physical.PhysicalPlan;

public final class PhysicalVerifier
extends PostOptimizationPhasePlanVerifier<PhysicalPlan> {
    public static final PhysicalVerifier LOCAL_INSTANCE = new PhysicalVerifier(true);
    public static final PhysicalVerifier INSTANCE = new PhysicalVerifier(false);

    private PhysicalVerifier(boolean isLocal) {
        super(isLocal);
    }

    @Override
    void checkPlanConsistency(PhysicalPlan optimizedPlan, Failures failures, Failures depFailures) {
        optimizedPlan.forEachDown(p -> {
            ExecutesOn ex2;
            FieldExtractExec fieldExtractExec;
            Attribute sourceAttribute;
            if (p instanceof FieldExtractExec && (sourceAttribute = (fieldExtractExec = (FieldExtractExec)p).sourceAttribute()) == null) {
                failures.add(Failure.fail(fieldExtractExec, "Need to add field extractor for [{}] but cannot detect source attributes from node [{}]", new Object[]{Expressions.names(fieldExtractExec.attributesToExtract()), fieldExtractExec.child()}));
            }
            if (!this.isLocal && p instanceof ExecutesOn && (ex2 = (ExecutesOn)((Object)p)).executesOn() == ExecutesOn.ExecuteLocation.REMOTE) {
                failures.add(Failure.fail(p, "Physical plan contains remote executing operation [{}] in local part. This usually means this command is incompatible with some of the preceding commands.", p.nodeName()));
            }
            PlanConsistencyChecker.checkPlan(p, depFailures);
            if (!failures.hasFailures()) {
                if (p instanceof PostPhysicalOptimizationVerificationAware) {
                    PostPhysicalOptimizationVerificationAware va = (PostPhysicalOptimizationVerificationAware)((Object)p);
                    va.postPhysicalOptimizationVerification(failures);
                }
                p.forEachExpression(ex -> {
                    if (ex instanceof PostPhysicalOptimizationVerificationAware) {
                        PostPhysicalOptimizationVerificationAware va = (PostPhysicalOptimizationVerificationAware)ex;
                        va.postPhysicalOptimizationVerification(failures);
                    }
                });
            }
        });
    }
}

