/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.esql.enrich;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.TransportVersion;
import org.elasticsearch.cluster.metadata.IndexNameExpressionResolver;
import org.elasticsearch.cluster.project.ProjectResolver;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.collect.Iterators;
import org.elasticsearch.common.io.stream.NamedWriteable;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Writeable;
import org.elasticsearch.common.util.BigArrays;
import org.elasticsearch.compute.data.Block;
import org.elasticsearch.compute.data.BlockFactory;
import org.elasticsearch.compute.data.BlockStreamInput;
import org.elasticsearch.compute.data.Page;
import org.elasticsearch.compute.operator.Warnings;
import org.elasticsearch.compute.operator.lookup.LookupEnrichQueryGenerator;
import org.elasticsearch.compute.operator.lookup.QueryList;
import org.elasticsearch.core.Releasable;
import org.elasticsearch.core.Releasables;
import org.elasticsearch.index.query.SearchExecutionContext;
import org.elasticsearch.index.shard.ShardId;
import org.elasticsearch.indices.IndicesService;
import org.elasticsearch.search.internal.AliasFilter;
import org.elasticsearch.tasks.TaskId;
import org.elasticsearch.transport.TransportService;
import org.elasticsearch.xpack.esql.EsqlIllegalArgumentException;
import org.elasticsearch.xpack.esql.core.expression.Expression;
import org.elasticsearch.xpack.esql.core.expression.NamedExpression;
import org.elasticsearch.xpack.esql.core.tree.Source;
import org.elasticsearch.xpack.esql.core.type.DataType;
import org.elasticsearch.xpack.esql.enrich.AbstractLookupService;
import org.elasticsearch.xpack.esql.enrich.ExpressionQueryList;
import org.elasticsearch.xpack.esql.enrich.MatchConfig;
import org.elasticsearch.xpack.esql.io.stream.PlanStreamInput;
import org.elasticsearch.xpack.esql.io.stream.PlanStreamOutput;
import org.elasticsearch.xpack.esql.plan.physical.FilterExec;
import org.elasticsearch.xpack.esql.plan.physical.FragmentExec;
import org.elasticsearch.xpack.esql.plan.physical.PhysicalPlan;
import org.elasticsearch.xpack.esql.planner.mapper.LocalMapper;

public class LookupFromIndexService
extends AbstractLookupService<Request, TransportRequest> {
    public static final String LOOKUP_ACTION_NAME = "indices:data/read/esql/lookup_from_index";
    private static final Logger logger = LogManager.getLogger(LookupFromIndexService.class);
    private static final TransportVersion ESQL_LOOKUP_JOIN_SOURCE_TEXT = TransportVersion.fromName((String)"esql_lookup_join_source_text");
    private static final TransportVersion ESQL_LOOKUP_JOIN_PRE_JOIN_FILTER = TransportVersion.fromName((String)"esql_lookup_join_pre_join_filter");

    public LookupFromIndexService(ClusterService clusterService, IndicesService indicesService, AbstractLookupService.LookupShardContextFactory lookupShardContextFactory, TransportService transportService, IndexNameExpressionResolver indexNameExpressionResolver, BigArrays bigArrays, BlockFactory blockFactory, ProjectResolver projectResolver) {
        super(LOOKUP_ACTION_NAME, clusterService, indicesService, lookupShardContextFactory, transportService, indexNameExpressionResolver, bigArrays, blockFactory, false, TransportRequest::readFrom, projectResolver);
    }

    @Override
    protected TransportRequest transportRequest(Request request, ShardId shardId) {
        return new TransportRequest(request.sessionId, shardId, request.indexPattern, request.inputPage, null, request.extractFields, request.matchFields, request.source, request.rightPreJoinPlan, request.joinOnConditions);
    }

    @Override
    protected LookupEnrichQueryGenerator queryList(TransportRequest request, SearchExecutionContext context, AliasFilter aliasFilter, Block inputBlock, Warnings warnings) {
        PhysicalPlan lookupNodePlan = LookupFromIndexService.localLookupNodePlanning(request.rightPreJoinPlan);
        if (request.joinOnConditions == null) {
            ArrayList<QueryList> queryLists = new ArrayList<QueryList>();
            for (int i = 0; i < request.matchFields.size(); ++i) {
                MatchConfig matchField = request.matchFields.get(i);
                QueryList q = LookupFromIndexService.termQueryList(context.getFieldType(matchField.fieldName()), context, aliasFilter, request.inputPage.getBlock(matchField.channel()), matchField.type()).onlySingleValues(warnings, "LOOKUP JOIN encountered multi-value");
                queryLists.add(q);
            }
            if (queryLists.size() == 1 && !(lookupNodePlan instanceof FilterExec)) {
                return (LookupEnrichQueryGenerator)queryLists.getFirst();
            }
            return ExpressionQueryList.fieldBasedJoin(queryLists, context, lookupNodePlan, this.clusterService, aliasFilter);
        }
        return ExpressionQueryList.expressionBasedJoin(context, lookupNodePlan, this.clusterService, request, aliasFilter, warnings);
    }

    private static PhysicalPlan localLookupNodePlanning(PhysicalPlan physicalPlan) {
        if (physicalPlan instanceof FragmentExec) {
            FragmentExec fragmentExec = (FragmentExec)physicalPlan;
            LocalMapper localMapper = new LocalMapper();
            return localMapper.map(fragmentExec.fragment());
        }
        return null;
    }

    @Override
    protected LookupResponse createLookupResponse(List<Page> pages, BlockFactory blockFactory) throws IOException {
        return new LookupResponse(pages, blockFactory);
    }

    @Override
    protected AbstractLookupService.LookupResponse readLookupResponse(StreamInput in, BlockFactory blockFactory) throws IOException {
        return new LookupResponse(in, blockFactory);
    }

    protected static class TransportRequest
    extends AbstractLookupService.TransportRequest {
        private static final TransportVersion JOIN_ON_ALIASES = TransportVersion.fromName((String)"join_on_aliases");
        private static final TransportVersion ESQL_LOOKUP_JOIN_ON_MANY_FIELDS = TransportVersion.fromName((String)"esql_lookup_join_on_many_fields");
        private static final TransportVersion ESQL_LOOKUP_JOIN_ON_EXPRESSION = TransportVersion.fromName((String)"esql_lookup_join_on_expression");
        private final List<MatchConfig> matchFields;
        private final PhysicalPlan rightPreJoinPlan;
        private final Expression joinOnConditions;

        TransportRequest(String sessionId, ShardId shardId, String indexPattern, Page inputPage, Page toRelease, List<NamedExpression> extractFields, List<MatchConfig> matchFields, Source source, PhysicalPlan rightPreJoinPlan, Expression joinOnConditions) {
            super(sessionId, shardId, indexPattern, inputPage, toRelease, extractFields, source);
            this.matchFields = matchFields;
            this.rightPreJoinPlan = rightPreJoinPlan;
            this.joinOnConditions = joinOnConditions;
        }

        static TransportRequest readFrom(StreamInput in, BlockFactory blockFactory) throws IOException {
            Page inputPage;
            TaskId parentTaskId = TaskId.readFromStream((StreamInput)in);
            String sessionId = in.readString();
            ShardId shardId = new ShardId(in);
            String indexPattern = in.getTransportVersion().supports(JOIN_ON_ALIASES) ? in.readString() : shardId.getIndexName();
            DataType inputDataType = null;
            if (!in.getTransportVersion().supports(ESQL_LOOKUP_JOIN_ON_MANY_FIELDS)) {
                inputDataType = DataType.fromTypeName((String)in.readString());
            }
            try (BlockStreamInput bsi = new BlockStreamInput(in, blockFactory);){
                inputPage = new Page((StreamInput)bsi);
            }
            PlanStreamInput planIn = new PlanStreamInput(in, in.namedWriteableRegistry(), null);
            List extractFields = planIn.readNamedWriteableCollectionAsList(NamedExpression.class);
            ArrayList<MatchConfig> matchFields = null;
            if (in.getTransportVersion().supports(ESQL_LOOKUP_JOIN_ON_MANY_FIELDS)) {
                matchFields = planIn.readCollectionAsList(MatchConfig::new);
            } else {
                String matchField = in.readString();
                matchFields = new ArrayList<MatchConfig>(1);
                matchFields.add(new MatchConfig(matchField, 0, inputDataType));
            }
            Source source = Source.readFrom((StreamInput)planIn);
            if (in.getTransportVersion().supports(ESQL_LOOKUP_JOIN_SOURCE_TEXT)) {
                String sourceText = in.readString();
                source = new Source(source.source(), sourceText);
            }
            PhysicalPlan rightPreJoinPlan = null;
            if (in.getTransportVersion().supports(ESQL_LOOKUP_JOIN_PRE_JOIN_FILTER)) {
                rightPreJoinPlan = (PhysicalPlan)planIn.readOptionalNamedWriteable(PhysicalPlan.class);
            }
            Expression joinOnConditions = null;
            if (in.getTransportVersion().supports(ESQL_LOOKUP_JOIN_ON_EXPRESSION)) {
                joinOnConditions = (Expression)planIn.readOptionalNamedWriteable(Expression.class);
            }
            TransportRequest result = new TransportRequest(sessionId, shardId, indexPattern, inputPage, inputPage, extractFields, matchFields, source, rightPreJoinPlan, joinOnConditions);
            result.setParentTask(parentTaskId);
            return result;
        }

        public Expression getJoinOnConditions() {
            return this.joinOnConditions;
        }

        public List<MatchConfig> getMatchFields() {
            return this.matchFields;
        }

        public void writeTo(StreamOutput out) throws IOException {
            super.writeTo(out);
            out.writeString(this.sessionId);
            out.writeWriteable((Writeable)this.shardId);
            if (out.getTransportVersion().supports(JOIN_ON_ALIASES)) {
                out.writeString(this.indexPattern);
            } else if (!this.indexPattern.equals(this.shardId.getIndexName())) {
                throw new EsqlIllegalArgumentException("Aliases and index patterns are not allowed for LOOKUP JOIN [{}]", this.indexPattern);
            }
            if (!out.getTransportVersion().supports(ESQL_LOOKUP_JOIN_ON_MANY_FIELDS)) {
                if (this.matchFields.size() > 1) {
                    throw new EsqlIllegalArgumentException("LOOKUP JOIN on multiple fields is not supported on remote node");
                }
                out.writeString(this.matchFields.get(0).type().typeName());
            }
            out.writeWriteable((Writeable)this.inputPage);
            PlanStreamOutput planOut = new PlanStreamOutput(out, null);
            planOut.writeNamedWriteableCollection(this.extractFields);
            if (out.getTransportVersion().supports(ESQL_LOOKUP_JOIN_ON_MANY_FIELDS)) {
                planOut.writeCollection(this.matchFields, (o, matchConfig) -> matchConfig.writeTo(o));
            } else {
                out.writeString(this.matchFields.get(0).fieldName());
            }
            this.source.writeTo((StreamOutput)planOut);
            if (out.getTransportVersion().supports(ESQL_LOOKUP_JOIN_SOURCE_TEXT)) {
                out.writeString(this.source.text());
            }
            if (out.getTransportVersion().supports(ESQL_LOOKUP_JOIN_PRE_JOIN_FILTER)) {
                planOut.writeOptionalNamedWriteable((NamedWriteable)this.rightPreJoinPlan);
            }
            if (out.getTransportVersion().supports(ESQL_LOOKUP_JOIN_ON_EXPRESSION)) {
                planOut.writeOptionalNamedWriteable((NamedWriteable)this.joinOnConditions);
            } else if (this.joinOnConditions != null) {
                throw new IllegalArgumentException("LOOKUP JOIN with ON conditions is not supported on remote node");
            }
        }

        @Override
        protected String extraDescription() {
            return " ,match_fields=" + this.matchFields.stream().map(MatchConfig::fieldName).collect(Collectors.joining(", ")) + ", right_pre_join_plan=" + (this.rightPreJoinPlan == null ? "null" : this.rightPreJoinPlan.toString());
        }
    }

    public static class Request
    extends AbstractLookupService.Request {
        private final List<MatchConfig> matchFields;
        private final PhysicalPlan rightPreJoinPlan;
        private final Expression joinOnConditions;

        Request(String sessionId, String index, String indexPattern, List<MatchConfig> matchFields, Page inputPage, List<NamedExpression> extractFields, Source source, PhysicalPlan rightPreJoinPlan, Expression joinOnConditions) {
            super(sessionId, index, indexPattern, matchFields.get(0).type(), inputPage, extractFields, source);
            this.matchFields = matchFields;
            this.rightPreJoinPlan = rightPreJoinPlan;
            this.joinOnConditions = joinOnConditions;
        }
    }

    protected static class LookupResponse
    extends AbstractLookupService.LookupResponse {
        private List<Page> pages;

        LookupResponse(List<Page> pages, BlockFactory blockFactory) {
            super(blockFactory);
            this.pages = pages;
        }

        LookupResponse(StreamInput in, BlockFactory blockFactory) throws IOException {
            super(blockFactory);
            try (BlockStreamInput bsi = new BlockStreamInput(in, blockFactory);){
                this.pages = bsi.readCollectionAsList(Page::new);
            }
        }

        public void writeTo(StreamOutput out) throws IOException {
            long bytes = this.pages.stream().mapToLong(Page::ramBytesUsedByBlocks).sum();
            this.blockFactory.breaker().addEstimateBytesAndMaybeBreak(bytes, "serialize lookup join response");
            this.reservedBytes += bytes;
            out.writeCollection(this.pages);
        }

        @Override
        protected List<Page> takePages() {
            List<Page> p = this.pages;
            this.pages = null;
            return p;
        }

        List<Page> pages() {
            return this.pages;
        }

        @Override
        protected void innerRelease() {
            if (this.pages != null) {
                Releasables.closeExpectNoException((Releasable)Releasables.wrap((Iterator)Iterators.map(this.pages.iterator(), page -> () -> ((Page)page).releaseBlocks())));
            }
        }

        public boolean equals(Object o) {
            if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
                return false;
            }
            LookupResponse that = (LookupResponse)((Object)o);
            return Objects.equals(this.pages, that.pages);
        }

        public int hashCode() {
            return Objects.hashCode(this.pages);
        }

        public String toString() {
            return "LookupResponse{pages=" + String.valueOf(this.pages) + "}";
        }
    }
}

