/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.compute.lucene;

import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.search.DocIdStream;
import org.apache.lucene.search.LeafCollector;
import org.apache.lucene.search.Scorable;
import org.apache.lucene.search.ScoreMode;
import org.apache.lucene.search.Weight;
import org.elasticsearch.compute.data.Block;
import org.elasticsearch.compute.data.BlockFactory;
import org.elasticsearch.compute.data.BlockUtils;
import org.elasticsearch.compute.data.ElementType;
import org.elasticsearch.compute.data.LongVector;
import org.elasticsearch.compute.data.Page;
import org.elasticsearch.compute.lucene.DataPartitioning;
import org.elasticsearch.compute.lucene.LuceneOperator;
import org.elasticsearch.compute.lucene.LuceneSliceQueue;
import org.elasticsearch.compute.lucene.ShardContext;
import org.elasticsearch.compute.operator.DriverContext;
import org.elasticsearch.compute.operator.SourceOperator;
import org.elasticsearch.core.RefCounted;
import org.elasticsearch.core.Releasable;
import org.elasticsearch.core.Releasables;

public class LuceneCountOperator
extends LuceneOperator {
    private final List<ElementType> tagTypes;
    private final Map<List<Object>, PerTagsState> tagsToState = new HashMap<List<Object>, PerTagsState>();
    private int remainingDocs;

    public LuceneCountOperator(List<? extends RefCounted> shardRefCounters, BlockFactory blockFactory, LuceneSliceQueue sliceQueue, List<ElementType> tagTypes, int limit) {
        super(shardRefCounters, blockFactory, Integer.MAX_VALUE, sliceQueue);
        this.tagTypes = tagTypes;
        this.remainingDocs = limit;
    }

    @Override
    public boolean isFinished() {
        return this.doneCollecting || this.remainingDocs == 0;
    }

    @Override
    public void finish() {
        this.doneCollecting = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected Page getCheckedOutput() throws IOException {
        if (this.isFinished()) {
            assert (this.remainingDocs <= 0) : this.remainingDocs;
            return null;
        }
        long start = System.nanoTime();
        try {
            LuceneOperator.LuceneScorer scorer = this.getCurrentOrLoadNextScorer();
            if (scorer == null) {
                this.remainingDocs = 0;
            } else {
                this.count(scorer);
            }
            if (this.remainingDocs <= 0) {
                Page page = this.buildResult();
                return page;
            }
            Page page = null;
            return page;
        }
        finally {
            this.processingNanos += System.nanoTime() - start;
        }
    }

    private void count(LuceneOperator.LuceneScorer scorer) throws IOException {
        LeafReaderContext leafReaderContext;
        PerTagsState state = this.tagsToState.computeIfAbsent(scorer.tags(), t -> new PerTagsState());
        Weight weight = scorer.weight();
        int leafCount = weight.count(leafReaderContext = scorer.leafReaderContext());
        if (leafCount != -1) {
            if (scorer.position() == 0) {
                int count = Math.min(leafCount, this.remainingDocs);
                state.totalHits += (long)count;
                this.remainingDocs -= count;
            }
            scorer.markAsDone();
        } else {
            scorer.scoreNextRange(state, leafReaderContext.reader().getLiveDocs(), this.remainingDocs);
        }
    }

    private Page buildResult() {
        return switch (this.tagsToState.size()) {
            case 0 -> null;
            case 1 -> {
                Map.Entry<List<Object>, PerTagsState> e = this.tagsToState.entrySet().iterator().next();
                yield this.buildConstantBlocksResult(e.getKey(), e.getValue());
            }
            default -> this.buildNonConstantBlocksResult();
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Page buildConstantBlocksResult(List<Object> tags, PerTagsState state) {
        Releasable[] blocks = new Block[2 + this.tagTypes.size()];
        int b = 0;
        try {
            blocks[b++] = this.blockFactory.newConstantLongBlockWith(state.totalHits, 1);
            blocks[b++] = this.blockFactory.newConstantBooleanBlockWith(true, 1);
            for (Object e : tags) {
                blocks[b++] = BlockUtils.constantBlock(this.blockFactory, e, 1);
            }
            Page page = new Page(1, (Block[])blocks);
            blocks = null;
            Page page2 = page;
            return page2;
        }
        finally {
            if (blocks != null) {
                Releasables.closeExpectNoException((Releasable[])blocks);
            }
        }
    }

    /*
     * Could not resolve type clashes
     * Loose catch block
     */
    private Page buildNonConstantBlocksResult() {
        Page page2;
        LongVector.Builder countBuilder;
        Releasable[] blocks;
        Releasable[] builders;
        block12: {
            builders = new BlockUtils.BuilderWrapper[this.tagTypes.size()];
            blocks = new Block[2 + this.tagTypes.size()];
            countBuilder = this.blockFactory.newLongVectorBuilder(this.tagsToState.size());
            int b = 0;
            for (ElementType t : this.tagTypes) {
                builders[b++] = BlockUtils.wrapperFor(this.blockFactory, t, this.tagsToState.size());
            }
            for (Map.Entry e : this.tagsToState.entrySet()) {
                countBuilder.appendLong(((PerTagsState)e.getValue()).totalHits);
                b = 0;
                for (Object t : (List)e.getKey()) {
                    builders[b++].accept(t);
                }
            }
            blocks[0] = countBuilder.build().asBlock();
            blocks[1] = this.blockFactory.newConstantBooleanBlockWith(true, this.tagsToState.size());
            for (b = 0; b < builders.length; ++b) {
                blocks[2 + b] = builders[b].builder().build();
                builders[b++] = null;
            }
            Page page2 = new Page(this.tagsToState.size(), (Block[])blocks);
            blocks = null;
            page2 = page2;
            if (countBuilder == null) break block12;
            countBuilder.close();
        }
        Releasables.closeExpectNoException((Releasable[])new Releasable[]{Releasables.wrap((Releasable[])builders), blocks == null ? () -> {} : Releasables.wrap((Releasable[])blocks)});
        return page2;
        {
            catch (Throwable throwable) {
                try {
                    if (countBuilder != null) {
                        try {
                            countBuilder.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Throwable throwable3) {
                    Releasables.closeExpectNoException((Releasable[])new Releasable[]{Releasables.wrap((Releasable[])builders), blocks == null ? () -> {} : Releasables.wrap((Releasable[])blocks)});
                    throw throwable3;
                }
            }
        }
    }

    @Override
    protected void describe(StringBuilder sb) {
        sb.append(", remainingDocs=").append(this.remainingDocs);
    }

    private class PerTagsState
    implements LeafCollector {
        long totalHits;

        private PerTagsState() {
        }

        public void setScorer(Scorable scorer) {
        }

        public void collect(DocIdStream stream) throws IOException {
            if (LuceneCountOperator.this.remainingDocs > 0) {
                int count = Math.min(stream.count(), LuceneCountOperator.this.remainingDocs);
                this.totalHits += (long)count;
                LuceneCountOperator.this.remainingDocs -= count;
            }
        }

        public void collect(int doc) {
            if (LuceneCountOperator.this.remainingDocs > 0) {
                --LuceneCountOperator.this.remainingDocs;
                ++this.totalHits;
            }
        }
    }

    public static class Factory
    extends LuceneOperator.Factory {
        private final List<? extends RefCounted> shardRefCounters;
        private final List<ElementType> tagTypes;

        public Factory(List<? extends ShardContext> contexts, Function<ShardContext, List<LuceneSliceQueue.QueryAndTags>> queryFunction, DataPartitioning dataPartitioning, int taskConcurrency, List<ElementType> tagTypes, int limit) {
            super(contexts, queryFunction, dataPartitioning, query -> LuceneSliceQueue.PartitioningStrategy.SHARD, taskConcurrency, limit, false, shardContext -> ScoreMode.COMPLETE_NO_SCORES);
            this.shardRefCounters = contexts;
            this.tagTypes = tagTypes;
        }

        @Override
        public SourceOperator get(DriverContext driverContext) {
            return new LuceneCountOperator(this.shardRefCounters, driverContext.blockFactory(), this.sliceQueue, this.tagTypes, this.limit);
        }

        @Override
        public String describe() {
            return "LuceneCountOperator[dataPartitioning = " + String.valueOf((Object)this.dataPartitioning) + ", limit = " + this.limit + "]";
        }
    }
}

