/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.compute.aggregation.spatial;

import java.util.List;
import org.apache.lucene.util.BytesRef;
import org.elasticsearch.compute.aggregation.AggregatorFunction;
import org.elasticsearch.compute.aggregation.IntermediateStateDesc;
import org.elasticsearch.compute.aggregation.spatial.SpatialExtentGeoPointSourceValuesAggregator;
import org.elasticsearch.compute.aggregation.spatial.SpatialExtentStateWrappedLongitudeState;
import org.elasticsearch.compute.data.Block;
import org.elasticsearch.compute.data.BooleanVector;
import org.elasticsearch.compute.data.BytesRefBlock;
import org.elasticsearch.compute.data.BytesRefVector;
import org.elasticsearch.compute.data.ElementType;
import org.elasticsearch.compute.data.IntBlock;
import org.elasticsearch.compute.data.IntVector;
import org.elasticsearch.compute.data.Page;
import org.elasticsearch.compute.operator.DriverContext;

public final class SpatialExtentGeoPointSourceValuesAggregatorFunction
implements AggregatorFunction {
    private static final List<IntermediateStateDesc> INTERMEDIATE_STATE_DESC = List.of(new IntermediateStateDesc("top", ElementType.INT), new IntermediateStateDesc("bottom", ElementType.INT), new IntermediateStateDesc("negLeft", ElementType.INT), new IntermediateStateDesc("negRight", ElementType.INT), new IntermediateStateDesc("posLeft", ElementType.INT), new IntermediateStateDesc("posRight", ElementType.INT));
    private final DriverContext driverContext;
    private final SpatialExtentStateWrappedLongitudeState state;
    private final List<Integer> channels;

    public SpatialExtentGeoPointSourceValuesAggregatorFunction(DriverContext driverContext, List<Integer> channels, SpatialExtentStateWrappedLongitudeState state) {
        this.driverContext = driverContext;
        this.channels = channels;
        this.state = state;
    }

    public static SpatialExtentGeoPointSourceValuesAggregatorFunction create(DriverContext driverContext, List<Integer> channels) {
        return new SpatialExtentGeoPointSourceValuesAggregatorFunction(driverContext, channels, SpatialExtentGeoPointSourceValuesAggregator.initSingle());
    }

    public static List<IntermediateStateDesc> intermediateStateDesc() {
        return INTERMEDIATE_STATE_DESC;
    }

    @Override
    public int intermediateBlockCount() {
        return INTERMEDIATE_STATE_DESC.size();
    }

    @Override
    public void addRawInput(Page page, BooleanVector mask) {
        if (!mask.allFalse()) {
            if (mask.allTrue()) {
                this.addRawInputNotMasked(page);
            } else {
                this.addRawInputMasked(page, mask);
            }
        }
    }

    private void addRawInputMasked(Page page, BooleanVector mask) {
        BytesRefBlock bytesBlock = (BytesRefBlock)page.getBlock(this.channels.get(0));
        BytesRefVector bytesVector = bytesBlock.asVector();
        if (bytesVector == null) {
            this.addRawBlock(bytesBlock, mask);
            return;
        }
        this.addRawVector(bytesVector, mask);
    }

    private void addRawInputNotMasked(Page page) {
        BytesRefBlock bytesBlock = (BytesRefBlock)page.getBlock(this.channels.get(0));
        BytesRefVector bytesVector = bytesBlock.asVector();
        if (bytesVector == null) {
            this.addRawBlock(bytesBlock);
            return;
        }
        this.addRawVector(bytesVector);
    }

    private void addRawVector(BytesRefVector bytesVector) {
        BytesRef bytesScratch = new BytesRef();
        for (int valuesPosition = 0; valuesPosition < bytesVector.getPositionCount(); ++valuesPosition) {
            BytesRef bytesValue = bytesVector.getBytesRef(valuesPosition, bytesScratch);
            SpatialExtentGeoPointSourceValuesAggregator.combine(this.state, bytesValue);
        }
    }

    private void addRawVector(BytesRefVector bytesVector, BooleanVector mask) {
        BytesRef bytesScratch = new BytesRef();
        for (int valuesPosition = 0; valuesPosition < bytesVector.getPositionCount(); ++valuesPosition) {
            if (!mask.getBoolean(valuesPosition)) continue;
            BytesRef bytesValue = bytesVector.getBytesRef(valuesPosition, bytesScratch);
            SpatialExtentGeoPointSourceValuesAggregator.combine(this.state, bytesValue);
        }
    }

    private void addRawBlock(BytesRefBlock bytesBlock) {
        BytesRef bytesScratch = new BytesRef();
        for (int p = 0; p < bytesBlock.getPositionCount(); ++p) {
            if (bytesBlock.isNull(p)) continue;
            int bytesStart = bytesBlock.getFirstValueIndex(p);
            int bytesEnd = bytesStart + bytesBlock.getValueCount(p);
            for (int bytesOffset = bytesStart; bytesOffset < bytesEnd; ++bytesOffset) {
                BytesRef bytesValue = bytesBlock.getBytesRef(bytesOffset, bytesScratch);
                SpatialExtentGeoPointSourceValuesAggregator.combine(this.state, bytesValue);
            }
        }
    }

    private void addRawBlock(BytesRefBlock bytesBlock, BooleanVector mask) {
        BytesRef bytesScratch = new BytesRef();
        for (int p = 0; p < bytesBlock.getPositionCount(); ++p) {
            if (!mask.getBoolean(p) || bytesBlock.isNull(p)) continue;
            int bytesStart = bytesBlock.getFirstValueIndex(p);
            int bytesEnd = bytesStart + bytesBlock.getValueCount(p);
            for (int bytesOffset = bytesStart; bytesOffset < bytesEnd; ++bytesOffset) {
                BytesRef bytesValue = bytesBlock.getBytesRef(bytesOffset, bytesScratch);
                SpatialExtentGeoPointSourceValuesAggregator.combine(this.state, bytesValue);
            }
        }
    }

    @Override
    public void addIntermediateInput(Page page) {
        assert (this.channels.size() == this.intermediateBlockCount());
        assert (page.getBlockCount() >= this.channels.get(0) + SpatialExtentGeoPointSourceValuesAggregatorFunction.intermediateStateDesc().size());
        Object topUncast = page.getBlock(this.channels.get(0));
        if (topUncast.areAllValuesNull()) {
            return;
        }
        IntVector top = ((IntBlock)topUncast).asVector();
        assert (top.getPositionCount() == 1);
        Object bottomUncast = page.getBlock(this.channels.get(1));
        if (bottomUncast.areAllValuesNull()) {
            return;
        }
        IntVector bottom = ((IntBlock)bottomUncast).asVector();
        assert (bottom.getPositionCount() == 1);
        Object negLeftUncast = page.getBlock(this.channels.get(2));
        if (negLeftUncast.areAllValuesNull()) {
            return;
        }
        IntVector negLeft = ((IntBlock)negLeftUncast).asVector();
        assert (negLeft.getPositionCount() == 1);
        Object negRightUncast = page.getBlock(this.channels.get(3));
        if (negRightUncast.areAllValuesNull()) {
            return;
        }
        IntVector negRight = ((IntBlock)negRightUncast).asVector();
        assert (negRight.getPositionCount() == 1);
        Object posLeftUncast = page.getBlock(this.channels.get(4));
        if (posLeftUncast.areAllValuesNull()) {
            return;
        }
        IntVector posLeft = ((IntBlock)posLeftUncast).asVector();
        assert (posLeft.getPositionCount() == 1);
        Object posRightUncast = page.getBlock(this.channels.get(5));
        if (posRightUncast.areAllValuesNull()) {
            return;
        }
        IntVector posRight = ((IntBlock)posRightUncast).asVector();
        assert (posRight.getPositionCount() == 1);
        SpatialExtentGeoPointSourceValuesAggregator.combineIntermediate(this.state, top.getInt(0), bottom.getInt(0), negLeft.getInt(0), negRight.getInt(0), posLeft.getInt(0), posRight.getInt(0));
    }

    @Override
    public void evaluateIntermediate(Block[] blocks, int offset, DriverContext driverContext) {
        this.state.toIntermediate(blocks, offset, driverContext);
    }

    @Override
    public void evaluateFinal(Block[] blocks, int offset, DriverContext driverContext) {
        blocks[offset] = SpatialExtentGeoPointSourceValuesAggregator.evaluateFinal(this.state, driverContext);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getClass().getSimpleName()).append("[");
        sb.append("channels=").append(this.channels);
        sb.append("]");
        return sb.toString();
    }

    public void close() {
        this.state.close();
    }
}

