/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.compute.aggregation;

import org.elasticsearch.common.util.BigArrays;
import org.elasticsearch.common.util.BitArray;
import org.elasticsearch.compute.aggregation.AggregatorState;
import org.elasticsearch.compute.aggregation.GroupingAggregatorEvaluationContext;
import org.elasticsearch.compute.aggregation.GroupingAggregatorState;
import org.elasticsearch.compute.aggregation.SeenGroupIds;
import org.elasticsearch.compute.data.Block;
import org.elasticsearch.compute.data.BlockFactory;
import org.elasticsearch.compute.data.BooleanBlock;
import org.elasticsearch.compute.data.IntVector;
import org.elasticsearch.compute.operator.DriverContext;
import org.elasticsearch.core.Releasable;
import org.elasticsearch.core.Releasables;

class ValuesBooleanAggregator {
    ValuesBooleanAggregator() {
    }

    public static SingleState initSingle() {
        return new SingleState();
    }

    public static void combine(SingleState state, boolean v) {
        if (v) {
            state.seenTrue = true;
        } else {
            state.seenFalse = true;
        }
    }

    public static void combineIntermediate(SingleState state, BooleanBlock values) {
        int start = values.getFirstValueIndex(0);
        int end = start + values.getValueCount(0);
        for (int i = start; i < end; ++i) {
            ValuesBooleanAggregator.combine(state, values.getBoolean(i));
        }
    }

    public static Block evaluateFinal(SingleState state, DriverContext driverContext) {
        return state.toBlock(driverContext.blockFactory());
    }

    public static GroupingState initGrouping(BigArrays bigArrays) {
        return new GroupingState(bigArrays);
    }

    public static void combine(GroupingState state, int groupId, boolean v) {
        long index = (long)groupId << 1 | (long)(v ? 1 : 0);
        state.values.set(index);
    }

    public static void combineIntermediate(GroupingState state, int groupId, BooleanBlock values, int valuesPosition) {
        int start = values.getFirstValueIndex(valuesPosition);
        int end = start + values.getValueCount(valuesPosition);
        for (int i = start; i < end; ++i) {
            ValuesBooleanAggregator.combine(state, groupId, values.getBoolean(i));
        }
    }

    public static Block evaluateFinal(GroupingState state, IntVector selected, GroupingAggregatorEvaluationContext ctx) {
        return state.toBlock(ctx.blockFactory(), selected);
    }

    public static class SingleState
    implements AggregatorState {
        private boolean seenFalse;
        private boolean seenTrue;

        @Override
        public void toIntermediate(Block[] blocks, int offset, DriverContext driverContext) {
            blocks[offset] = this.toBlock(driverContext.blockFactory());
        }

        Block toBlock(BlockFactory blockFactory) {
            if (!this.seenFalse && !this.seenTrue) {
                return blockFactory.newConstantNullBlock(1);
            }
            try (BooleanBlock.Builder builder = blockFactory.newBooleanBlockBuilder(2);){
                builder.beginPositionEntry();
                if (this.seenFalse) {
                    builder.appendBoolean(false);
                }
                if (this.seenTrue) {
                    builder.appendBoolean(true);
                }
                builder.endPositionEntry();
                BooleanBlock booleanBlock = builder.build();
                return booleanBlock;
            }
        }

        public void close() {
        }
    }

    public static class GroupingState
    implements GroupingAggregatorState {
        private final BitArray values;

        private GroupingState(BigArrays bigArrays) {
            this.values = new BitArray(1L, bigArrays);
        }

        @Override
        public void toIntermediate(Block[] blocks, int offset, IntVector selected, DriverContext driverContext) {
            blocks[offset] = this.toBlock(driverContext.blockFactory(), selected);
        }

        Block toBlock(BlockFactory blockFactory, IntVector selected) {
            if (this.values.size() == 0L) {
                return blockFactory.newConstantNullBlock(selected.getPositionCount());
            }
            try (BooleanBlock.Builder builder = blockFactory.newBooleanBlockBuilder(selected.getPositionCount());){
                for (int s = 0; s < selected.getPositionCount(); ++s) {
                    int selectedGroup = selected.getInt(s);
                    long index = (long)selectedGroup << 1;
                    boolean seenFalse = this.values.get(index);
                    boolean seenTrue = this.values.get(index | 1L);
                    if (seenFalse) {
                        if (seenTrue) {
                            builder.beginPositionEntry();
                            builder.appendBoolean(false);
                            builder.appendBoolean(true);
                            builder.endPositionEntry();
                            continue;
                        }
                        builder.appendBoolean(false);
                        continue;
                    }
                    if (seenTrue) {
                        builder.appendBoolean(true);
                        continue;
                    }
                    builder.appendNull();
                }
                BooleanBlock booleanBlock = builder.build();
                return booleanBlock;
            }
        }

        @Override
        public void enableGroupIdTracking(SeenGroupIds seen) {
        }

        public void close() {
            Releasables.closeExpectNoException((Releasable)this.values);
        }
    }
}

