/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.compute.aggregation;

import java.util.List;
import org.elasticsearch.compute.aggregation.AggregatorFunctionSupplier;
import org.elasticsearch.compute.aggregation.IntermediateStateDesc;
import org.elasticsearch.compute.aggregation.PercentileDoubleAggregatorFunction;
import org.elasticsearch.compute.aggregation.PercentileDoubleGroupingAggregatorFunction;
import org.elasticsearch.compute.operator.DriverContext;

public final class PercentileDoubleAggregatorFunctionSupplier
implements AggregatorFunctionSupplier {
    private final double percentile;

    public PercentileDoubleAggregatorFunctionSupplier(double percentile) {
        this.percentile = percentile;
    }

    @Override
    public List<IntermediateStateDesc> nonGroupingIntermediateStateDesc() {
        return PercentileDoubleAggregatorFunction.intermediateStateDesc();
    }

    @Override
    public List<IntermediateStateDesc> groupingIntermediateStateDesc() {
        return PercentileDoubleGroupingAggregatorFunction.intermediateStateDesc();
    }

    @Override
    public PercentileDoubleAggregatorFunction aggregator(DriverContext driverContext, List<Integer> channels) {
        return PercentileDoubleAggregatorFunction.create(driverContext, channels, this.percentile);
    }

    @Override
    public PercentileDoubleGroupingAggregatorFunction groupingAggregator(DriverContext driverContext, List<Integer> channels) {
        return PercentileDoubleGroupingAggregatorFunction.create(channels, driverContext, this.percentile);
    }

    @Override
    public String describe() {
        return "percentile of doubles";
    }
}

