/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.security.action;

import java.io.IOException;
import java.util.Objects;
import org.elasticsearch.action.ActionResponse;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.core.TimeValue;
import org.elasticsearch.xcontent.ParseField;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.ToXContentObject;
import org.elasticsearch.xcontent.XContentBuilder;
import org.elasticsearch.xpack.core.security.authc.Authentication;

public final class DelegatePkiAuthenticationResponse
extends ActionResponse
implements ToXContentObject {
    private static final ParseField ACCESS_TOKEN_FIELD = new ParseField("access_token", new String[0]);
    private static final ParseField TYPE_FIELD = new ParseField("type", new String[0]);
    private static final ParseField EXPIRES_IN_FIELD = new ParseField("expires_in", new String[0]);
    private static final ParseField AUTHENTICATION = new ParseField("authentication", new String[0]);
    private final String accessToken;
    private final TimeValue expiresIn;
    private Authentication authentication;

    public DelegatePkiAuthenticationResponse(String accessToken, TimeValue expiresIn, Authentication authentication) {
        this.accessToken = Objects.requireNonNull(accessToken);
        this.expiresIn = TimeValue.timeValueSeconds((long)Objects.requireNonNull(expiresIn).getSeconds());
        this.authentication = authentication;
    }

    public DelegatePkiAuthenticationResponse(StreamInput input) throws IOException {
        this.accessToken = input.readString();
        this.expiresIn = input.readTimeValue();
        this.authentication = new Authentication(input);
    }

    public String getAccessToken() {
        return this.accessToken;
    }

    public TimeValue getExpiresIn() {
        return this.expiresIn;
    }

    public Authentication getAuthentication() {
        return this.authentication;
    }

    public void writeTo(StreamOutput out) throws IOException {
        out.writeString(this.accessToken);
        out.writeTimeValue(this.expiresIn);
        this.authentication.writeTo(out);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        DelegatePkiAuthenticationResponse that = (DelegatePkiAuthenticationResponse)((Object)o);
        return Objects.equals(this.accessToken, that.accessToken) && Objects.equals(this.expiresIn, that.expiresIn) && Objects.equals(this.authentication, that.authentication);
    }

    public int hashCode() {
        return Objects.hash(this.accessToken, this.expiresIn, this.authentication);
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        builder.field(ACCESS_TOKEN_FIELD.getPreferredName(), this.accessToken);
        builder.field(TYPE_FIELD.getPreferredName(), "Bearer");
        builder.field(EXPIRES_IN_FIELD.getPreferredName(), this.expiresIn.getSeconds());
        if (this.authentication != null) {
            builder.field(AUTHENTICATION.getPreferredName(), (ToXContent)this.authentication);
        }
        return builder.endObject();
    }
}

