/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.ilm;

import java.util.function.LongSupplier;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.action.admin.indices.rollover.RolloverInfo;
import org.elasticsearch.cluster.ProjectState;
import org.elasticsearch.cluster.metadata.IndexAbstraction;
import org.elasticsearch.cluster.metadata.IndexMetadata;
import org.elasticsearch.cluster.metadata.LifecycleExecutionState;
import org.elasticsearch.cluster.metadata.ProjectMetadata;
import org.elasticsearch.common.Strings;
import org.elasticsearch.index.Index;
import org.elasticsearch.xpack.core.ilm.ClusterStateActionStep;
import org.elasticsearch.xpack.core.ilm.LifecycleSettings;
import org.elasticsearch.xpack.core.ilm.RolloverAction;
import org.elasticsearch.xpack.core.ilm.Step;

public class UpdateRolloverLifecycleDateStep
extends ClusterStateActionStep {
    private static final Logger logger = LogManager.getLogger(UpdateRolloverLifecycleDateStep.class);
    public static final String NAME = "update-rollover-lifecycle-date";
    private final LongSupplier fallbackTimeSupplier;

    public UpdateRolloverLifecycleDateStep(Step.StepKey key, Step.StepKey nextStepKey, LongSupplier fallbackTimeSupplier) {
        super(key, nextStepKey);
        this.fallbackTimeSupplier = fallbackTimeSupplier;
    }

    @Override
    public boolean isRetryable() {
        return true;
    }

    @Override
    public ProjectState performAction(Index index, ProjectState projectState) {
        long newIndexTime;
        IndexMetadata indexMetadata = projectState.metadata().getIndexSafe(index);
        boolean indexingComplete = (Boolean)LifecycleSettings.LIFECYCLE_INDEXING_COMPLETE_SETTING.get(indexMetadata.getSettings());
        if (indexingComplete) {
            logger.trace("{} has lifecycle complete set, skipping {}", (Object)indexMetadata.getIndex(), (Object)NAME);
            newIndexTime = this.fallbackTimeSupplier.getAsLong();
        } else {
            String rolloverTarget = UpdateRolloverLifecycleDateStep.getRolloverTarget(index, projectState.metadata());
            RolloverInfo rolloverInfo = (RolloverInfo)indexMetadata.getRolloverInfos().get(rolloverTarget);
            if (rolloverInfo == null) {
                throw new IllegalStateException("no rollover info found for [" + indexMetadata.getIndex().getName() + "] with rollover target [" + rolloverTarget + "], the index has not yet rolled over with that target");
            }
            newIndexTime = rolloverInfo.getTime();
        }
        LifecycleExecutionState.Builder newLifecycleState = LifecycleExecutionState.builder((LifecycleExecutionState)indexMetadata.getLifecycleExecutionState());
        newLifecycleState.setIndexCreationDate(Long.valueOf(newIndexTime));
        return projectState.updateProject(projectState.metadata().withLifecycleState(indexMetadata.getIndex(), newLifecycleState.build()));
    }

    private static String getRolloverTarget(Index index, ProjectMetadata project) {
        String rolloverTarget;
        IndexAbstraction indexAbstraction = (IndexAbstraction)project.getIndicesLookup().get(index.getName());
        if (indexAbstraction.getParentDataStream() != null) {
            rolloverTarget = indexAbstraction.getParentDataStream().getName();
        } else {
            IndexMetadata indexMetadata = project.index(index);
            String rolloverAlias = (String)RolloverAction.LIFECYCLE_ROLLOVER_ALIAS_SETTING.get(indexMetadata.getSettings());
            if (Strings.isNullOrEmpty((String)rolloverAlias)) {
                throw new IllegalStateException("setting [index.lifecycle.rollover_alias] is not set on index [" + indexMetadata.getIndex().getName() + "]");
            }
            rolloverTarget = rolloverAlias;
        }
        return rolloverTarget;
    }

    @Override
    public int hashCode() {
        return super.hashCode();
    }

    @Override
    public boolean equals(Object obj) {
        return obj != null && this.getClass() == obj.getClass() && super.equals(obj);
    }
}

