/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.core;

import java.util.Iterator;
import java.util.Objects;
import org.elasticsearch.core.Releasable;
import org.elasticsearch.core.Releasables;

public interface ReleasableIterator<T>
extends Releasable,
Iterator<T> {
    public static <T extends Releasable> ReleasableIterator<T> single(final T element) {
        return new ReleasableIterator<T>(){
            private T value;
            {
                this.value = Objects.requireNonNull(element);
            }

            @Override
            public boolean hasNext() {
                return this.value != null;
            }

            @Override
            public T next() {
                Object res = this.value;
                this.value = null;
                return res;
            }

            @Override
            public void close() {
                Releasables.close(this.value);
            }

            public String toString() {
                return "ReleasableIterator[" + String.valueOf(this.value) + "]";
            }
        };
    }

    public static <T extends Releasable> ReleasableIterator<T> empty() {
        return new ReleasableIterator<T>(){

            @Override
            public boolean hasNext() {
                return false;
            }

            @Override
            public T next() {
                assert (false) : "hasNext is always false so next should never be called";
                return null;
            }

            @Override
            public void close() {
            }

            public String toString() {
                return "ReleasableIterator[<empty>]";
            }
        };
    }
}

