/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.security;

import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.Executor;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.Version;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.support.GroupedActionListener;
import org.elasticsearch.bootstrap.BootstrapInfo;
import org.elasticsearch.bootstrap.ConsoleLoader;
import org.elasticsearch.client.internal.Client;
import org.elasticsearch.cluster.metadata.Metadata;
import org.elasticsearch.common.BackoffPolicy;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.util.concurrent.AbstractRunnable;
import org.elasticsearch.core.TimeValue;
import org.elasticsearch.env.Environment;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.xpack.core.XPackSettings;
import org.elasticsearch.xpack.core.ssl.SSLService;
import org.elasticsearch.xpack.security.authc.esnative.NativeUsersStore;
import org.elasticsearch.xpack.security.authc.esnative.ReservedRealm;
import org.elasticsearch.xpack.security.enrollment.InternalEnrollmentTokenGenerator;
import org.elasticsearch.xpack.security.support.SecurityIndexManager;
import org.elasticsearch.xpack.security.tool.CommandUtils;

public class InitialNodeSecurityAutoConfiguration {
    private static final Logger LOGGER = LogManager.getLogger(InitialNodeSecurityAutoConfiguration.class);
    private static final BackoffPolicy BACKOFF_POLICY = BackoffPolicy.exponentialBackoff();

    private InitialNodeSecurityAutoConfiguration() {
        throw new IllegalStateException("Class should not be instantiated");
    }

    public static void maybeGenerateEnrollmentTokensAndElasticCredentialsOnNodeStartup(final NativeUsersStore nativeUsersStore, SecurityIndexManager securityIndexManager, SSLService sslService, Client client, final Environment environment, OnNodeStartedListener onNodeStartedListener, ThreadPool threadPool) {
        if (!((Boolean)XPackSettings.ENROLLMENT_ENABLED.get(environment.settings())).booleanValue()) {
            return;
        }
        final InternalEnrollmentTokenGenerator enrollmentTokenGenerator = new InternalEnrollmentTokenGenerator(environment, sslService, client);
        final ConsoleLoader.Console console = InitialNodeSecurityAutoConfiguration.getConsole();
        if (console == null) {
            LOGGER.info("Auto-configuration will not generate a password for the elastic built-in superuser, as we cannot  determine if there is a terminal attached to the elasticsearch process. You can use the `bin/elasticsearch-reset-password` tool to set the password for the elastic user.");
            return;
        }
        securityIndexManager.whenProjectStateAvailable(Metadata.DEFAULT_PROJECT_ID, securityIndexState -> {
            if (!securityIndexState.indexExists()) {
                onNodeStartedListener.run(() -> threadPool.schedule((Runnable)new AbstractRunnable(){

                    public void onFailure(Exception e) {
                        LOGGER.error("Unexpected exception when auto configuring the initial node for Security", (Throwable)e);
                    }

                    protected void doRun() {
                        String fingerprint;
                        try {
                            fingerprint = enrollmentTokenGenerator.getHttpsCaFingerprint();
                            LOGGER.info("HTTPS has been configured with automatically generated certificates, and the CA's hex-encoded SHA-256 fingerprint is [" + fingerprint + "]");
                        }
                        catch (Exception e2) {
                            fingerprint = null;
                            LOGGER.error("Failed to compute the HTTPS CA fingerprint, probably the certs are not auto-generated", (Throwable)e2);
                        }
                        String httpsCaFingerprint = fingerprint;
                        GroupedActionListener groupedActionListener = new GroupedActionListener(3, ActionListener.wrap(results -> {
                            HashMap allResultsMap = new HashMap();
                            for (Map result : results) {
                                allResultsMap.putAll(result);
                            }
                            String elasticPassword = (String)allResultsMap.get("generated_elastic_user_password");
                            String kibanaEnrollmentToken = (String)allResultsMap.get("kibana_enrollment_token");
                            String nodeEnrollmentToken = (String)allResultsMap.get("node_enrollment_token");
                            InitialNodeSecurityAutoConfiguration.outputInformationToConsole(elasticPassword, kibanaEnrollmentToken, nodeEnrollmentToken, httpsCaFingerprint, console);
                        }, e -> LOGGER.error("Unexpected exception during security auto-configuration", (Throwable)e)));
                        if (!ReservedRealm.BOOTSTRAP_ELASTIC_PASSWORD.exists(environment.settings()) && !ReservedRealm.AUTOCONFIG_ELASTIC_PASSWORD_HASH.exists(environment.settings())) {
                            char[] elasticPassword = CommandUtils.generatePassword(20);
                            nativeUsersStore.createElasticUser(elasticPassword, (ActionListener<Void>)ActionListener.wrap(aVoid -> {
                                LOGGER.debug("elastic credentials generated successfully");
                                groupedActionListener.onResponse(Map.of("generated_elastic_user_password", new String(elasticPassword)));
                            }, e -> {
                                LOGGER.error("Failed to generate credentials for the elastic built-in superuser", (Throwable)e);
                                groupedActionListener.onResponse(Map.of());
                            }));
                        } else {
                            if (!ReservedRealm.BOOTSTRAP_ELASTIC_PASSWORD.exists(environment.settings())) {
                                LOGGER.info("Auto-configuration will not generate a password for the elastic built-in superuser, you should use the password specified in the node's secure setting [" + ReservedRealm.BOOTSTRAP_ELASTIC_PASSWORD.getKey() + "] in order to authenticate as elastic");
                            }
                            groupedActionListener.onResponse(Map.of("generated_elastic_user_password", ""));
                        }
                        Iterator backoff = BACKOFF_POLICY.iterator();
                        enrollmentTokenGenerator.createKibanaEnrollmentToken(kibanaToken -> {
                            if (kibanaToken != null) {
                                try {
                                    LOGGER.debug("Successfully generated the kibana enrollment token");
                                    groupedActionListener.onResponse(Map.of("kibana_enrollment_token", kibanaToken.getEncoded()));
                                }
                                catch (Exception e) {
                                    LOGGER.error("Failed to encode kibana enrollment token", (Throwable)e);
                                    groupedActionListener.onResponse(Map.of());
                                }
                            } else {
                                groupedActionListener.onResponse(Map.of());
                            }
                        }, backoff);
                        enrollmentTokenGenerator.maybeCreateNodeEnrollmentToken(encodedNodeToken -> {
                            if (encodedNodeToken != null) {
                                groupedActionListener.onResponse(Map.of("node_enrollment_token", encodedNodeToken));
                            } else {
                                groupedActionListener.onResponse(Map.of());
                            }
                        }, backoff);
                    }
                }, TimeValue.timeValueSeconds((long)9L), (Executor)threadPool.generic()));
            }
        });
    }

    private static ConsoleLoader.Console getConsole() {
        ConsoleLoader.Console console = BootstrapInfo.getConsole();
        if (console == null) {
            return null;
        }
        console.printStream().println();
        if (console.printStream().checkError()) {
            return null;
        }
        return console;
    }

    private static void outputInformationToConsole(String elasticPassword, String kibanaEnrollmentToken, String nodeEnrollmentToken, String caCertFingerprint, ConsoleLoader.Console console) {
        boolean useUnicode = StandardCharsets.UTF_8.equals(console.charset()) || StandardCharsets.UTF_16.equals(console.charset()) || StandardCharsets.UTF_16LE.equals(console.charset()) || StandardCharsets.UTF_16BE.equals(console.charset());
        String infoBullet = useUnicode ? "\u2139\ufe0f" : "->";
        String bullet = useUnicode ? "\u2022" : "*";
        String hyphenBullet = useUnicode ? "\u2043" : "-";
        String errorBullet = useUnicode ? "\u274c" : "X";
        String successBullet = useUnicode ? "\u2705" : "->";
        String horizontalBorderLine = useUnicode ? "\u2501" : "-";
        String boldOnANSI = console.ansiEnabled() != false ? "\u001b[1m" : "";
        String boldOffANSI = console.ansiEnabled() != false ? "\u001b[22m" : "";
        String cmdOn = "`";
        String cmdOff = "`";
        int horizontalBorderLength = (Integer)console.width().get();
        StringBuilder builder = new StringBuilder();
        builder.append(System.lineSeparator());
        builder.append(System.lineSeparator());
        builder.append(System.lineSeparator());
        builder.append(System.lineSeparator());
        builder.append(horizontalBorderLine.repeat(horizontalBorderLength));
        builder.append(System.lineSeparator());
        builder.append(successBullet + " Elasticsearch security features have been automatically configured!");
        builder.append(System.lineSeparator());
        builder.append(successBullet + " Authentication is enabled and cluster connections are encrypted.");
        builder.append(System.lineSeparator());
        builder.append(System.lineSeparator());
        if (elasticPassword == null) {
            builder.append(errorBullet + " Unable to auto-generate the password for the " + boldOnANSI + "elastic" + boldOffANSI + " built-in superuser.");
        } else if (!Strings.isEmpty((CharSequence)elasticPassword)) {
            builder.append(infoBullet + "  Password for the " + boldOnANSI + "elastic" + boldOffANSI + " user (reset with `bin/elasticsearch-reset-password -u elastic`):");
            builder.append(System.lineSeparator());
            builder.append("  " + boldOnANSI + elasticPassword + boldOffANSI);
        }
        builder.append(System.lineSeparator());
        builder.append(System.lineSeparator());
        if (null != caCertFingerprint) {
            builder.append(infoBullet + "  HTTP CA certificate SHA-256 fingerprint:");
            builder.append(System.lineSeparator());
            builder.append("  " + boldOnANSI + caCertFingerprint + boldOffANSI);
        }
        builder.append(System.lineSeparator());
        builder.append(System.lineSeparator());
        if (null != kibanaEnrollmentToken) {
            builder.append(infoBullet + "  Configure Kibana to use this cluster:");
            builder.append(System.lineSeparator());
            builder.append(bullet + " Run Kibana and click the configuration link in the terminal when Kibana starts.");
            builder.append(System.lineSeparator());
            builder.append(bullet + " Copy the following enrollment token and paste it into Kibana in your browser ");
            builder.append("(valid for the next 30 minutes):");
            builder.append(System.lineSeparator());
            builder.append("  " + boldOnANSI + kibanaEnrollmentToken + boldOffANSI);
        } else {
            builder.append(errorBullet + " Unable to generate an enrollment token for Kibana instances, ");
            builder.append("try invoking `bin/elasticsearch-create-enrollment-token -s kibana`.");
        }
        builder.append(System.lineSeparator());
        builder.append(System.lineSeparator());
        if (null == nodeEnrollmentToken) {
            builder.append(errorBullet + " An enrollment token to enroll new nodes wasn't generated.");
            builder.append(" To add nodes and enroll them into this cluster:");
            builder.append(System.lineSeparator());
            builder.append(bullet + " On this node:");
            builder.append(System.lineSeparator());
            builder.append("  " + hyphenBullet + " Create an enrollment token with `bin/elasticsearch-create-enrollment-token -s node`.");
            builder.append(System.lineSeparator());
            builder.append("  " + hyphenBullet + " Restart Elasticsearch.");
            builder.append(System.lineSeparator());
            builder.append(bullet + " On other nodes:");
            builder.append(System.lineSeparator());
            builder.append("  " + hyphenBullet + " Start Elasticsearch with `bin/elasticsearch --enrollment-token <token>`, using the enrollment token that you generated.");
        } else if (Strings.isEmpty((CharSequence)nodeEnrollmentToken)) {
            builder.append(infoBullet + "  Configure other nodes to join this cluster:");
            builder.append(System.lineSeparator());
            builder.append(bullet + " On this node:");
            builder.append(System.lineSeparator());
            builder.append("  " + hyphenBullet + " Create an enrollment token with `bin/elasticsearch-create-enrollment-token -s node`.");
            builder.append(System.lineSeparator());
            builder.append("  " + hyphenBullet + " Uncomment the " + boldOnANSI + "transport.host" + boldOffANSI + " setting at the end of " + boldOnANSI + "config/elasticsearch.yml" + boldOffANSI + ".");
            builder.append(System.lineSeparator());
            builder.append("  " + hyphenBullet + " Restart Elasticsearch.");
            builder.append(System.lineSeparator());
            builder.append(bullet + " On other nodes:");
            builder.append(System.lineSeparator());
            builder.append("  " + hyphenBullet + " Start Elasticsearch with `bin/elasticsearch --enrollment-token <token>`, using the enrollment token that you generated.");
        } else {
            builder.append(infoBullet + " Configure other nodes to join this cluster:");
            builder.append(System.lineSeparator());
            builder.append(bullet + " Copy the following enrollment token and start new Elasticsearch nodes with `bin/elasticsearch --enrollment-token <token>` (valid for the next 30 minutes):");
            builder.append(System.lineSeparator());
            builder.append("  " + boldOnANSI + nodeEnrollmentToken + boldOffANSI);
            builder.append(System.lineSeparator());
            builder.append(System.lineSeparator());
            builder.append("  If you're running in Docker, copy the enrollment token and run:");
            builder.append(System.lineSeparator());
            builder.append("  `docker run -e \"ENROLLMENT_TOKEN=<token>\" docker.elastic.co/elasticsearch/elasticsearch:" + String.valueOf(Version.CURRENT) + "`");
        }
        builder.append(System.lineSeparator());
        builder.append(horizontalBorderLine.repeat(horizontalBorderLength));
        builder.append(System.lineSeparator());
        builder.append(System.lineSeparator());
        builder.append(System.lineSeparator());
        builder.append(System.lineSeparator());
        console.printStream().println(builder);
    }

    static interface OnNodeStartedListener {
        public void run(Runnable var1);
    }
}

