/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.test;

import java.io.IOException;
import java.util.Iterator;
import java.util.function.Function;
import org.elasticsearch.ElasticsearchParseException;
import org.elasticsearch.cluster.AbstractNamedDiffable;
import org.elasticsearch.cluster.NamedDiff;
import org.elasticsearch.cluster.metadata.Metadata;
import org.elasticsearch.common.collect.Iterators;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.XContentParser;

public abstract class TestClusterCustomMetadata
extends AbstractNamedDiffable<Metadata.ClusterCustom>
implements Metadata.ClusterCustom {
    private final String data;

    protected TestClusterCustomMetadata(String data) {
        this.data = data;
    }

    public String getData() {
        return this.data;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        TestClusterCustomMetadata that = (TestClusterCustomMetadata)((Object)o);
        return this.data.equals(that.data);
    }

    public int hashCode() {
        return this.data.hashCode();
    }

    public static <T extends TestClusterCustomMetadata> T readFrom(Function<String, T> supplier, StreamInput in) throws IOException {
        return (T)((Object)((TestClusterCustomMetadata)((Object)supplier.apply(in.readString()))));
    }

    public static NamedDiff<Metadata.ClusterCustom> readDiffFrom(String name, StreamInput in) throws IOException {
        return TestClusterCustomMetadata.readDiffFrom(Metadata.ClusterCustom.class, (String)name, (StreamInput)in);
    }

    public void writeTo(StreamOutput out) throws IOException {
        out.writeString(this.getData());
    }

    public static <T extends Metadata.ClusterCustom> T fromXContent(Function<String, T> supplier, XContentParser parser) throws IOException {
        XContentParser.Token token;
        String data = null;
        while ((token = parser.nextToken()) != XContentParser.Token.END_OBJECT) {
            if (token == XContentParser.Token.FIELD_NAME) {
                String currentFieldName = parser.currentName();
                if ("data".equals(currentFieldName)) {
                    if (parser.nextToken() != XContentParser.Token.VALUE_STRING) {
                        throw new ElasticsearchParseException("failed to parse snapshottable metadata, invalid data type", new Object[0]);
                    }
                    data = parser.text();
                    continue;
                }
                throw new ElasticsearchParseException("failed to parse snapshottable metadata, unknown field [{}]", new Object[]{currentFieldName});
            }
            throw new ElasticsearchParseException("failed to parse snapshottable metadata", new Object[0]);
        }
        if (data == null) {
            throw new ElasticsearchParseException("failed to parse snapshottable metadata, data not found", new Object[0]);
        }
        return (T)((Metadata.ClusterCustom)supplier.apply(data));
    }

    public Iterator<? extends ToXContent> toXContentChunked(ToXContent.Params ignored) {
        return Iterators.single((builder, params) -> builder.field("data", this.getData()));
    }

    public String toString() {
        return "[" + this.getWriteableName() + "][" + this.data + "]";
    }
}

