/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.datageneration.queries;

import java.util.List;
import java.util.Map;
import org.apache.lucene.search.join.ScoreMode;
import org.elasticsearch.datageneration.Mapping;
import org.elasticsearch.datageneration.queries.LeafQueryGenerator;
import org.elasticsearch.datageneration.queries.MappingPredicates;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.QueryBuilders;

public class QueryGenerator {
    private final Mapping mapping;
    private final MappingPredicates mappingPredicates;

    public QueryGenerator(Mapping mapping) {
        this.mapping = mapping;
        this.mappingPredicates = new MappingPredicates(mapping);
    }

    public List<QueryBuilder> generateQueries(String type, String path, Object value) {
        if (path.equals("host.name")) {
            return List.of();
        }
        if (this.mappingPredicates.isRuntimeField(path)) {
            return List.of();
        }
        LeafQueryGenerator leafQueryGenerator = LeafQueryGenerator.buildForType(type, this.mappingPredicates);
        Map<String, Object> fieldMapping = this.mapping.lookup().get(path);
        List<QueryBuilder> leafQueries = leafQueryGenerator.generate(fieldMapping, path, value);
        return leafQueries.stream().map(q -> this.wrapInNestedQuery(path, (QueryBuilder)q)).toList();
    }

    private QueryBuilder wrapInNestedQuery(String path, QueryBuilder leafQuery) {
        List<String> nestedPaths = this.mappingPredicates.getNestedPathPrefixes(path);
        QueryBuilder query = leafQuery;
        for (String nestedPath : nestedPaths.reversed()) {
            query = QueryBuilders.nestedQuery((String)nestedPath, (QueryBuilder)query, (ScoreMode)ScoreMode.Max);
        }
        return query;
    }
}

