/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.usage;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.LongAdder;
import java.util.function.Function;
import org.elasticsearch.action.admin.cluster.stats.ExtendedSearchUsageLongCounter;
import org.elasticsearch.action.admin.cluster.stats.ExtendedSearchUsageMetric;
import org.elasticsearch.action.admin.cluster.stats.ExtendedSearchUsageStats;
import org.elasticsearch.action.admin.cluster.stats.SearchUsageStats;
import org.elasticsearch.common.util.Maps;
import org.elasticsearch.usage.SearchUsage;

public final class SearchUsageHolder {
    private final LongAdder totalSearchCount = new LongAdder();
    private final Map<String, LongAdder> queriesUsage = new ConcurrentHashMap<String, LongAdder>();
    private final Map<String, LongAdder> rescorersUsage = new ConcurrentHashMap<String, LongAdder>();
    private final Map<String, LongAdder> sectionsUsage = new ConcurrentHashMap<String, LongAdder>();
    private final Map<String, LongAdder> retrieversUsage = new ConcurrentHashMap<String, LongAdder>();
    private final Map<String, Map<String, Map<String, LongAdder>>> extendedSearchUsage = new ConcurrentHashMap<String, Map<String, Map<String, LongAdder>>>();

    SearchUsageHolder() {
    }

    public void updateUsage(SearchUsage searchUsage) {
        this.totalSearchCount.increment();
        for (String section : searchUsage.getSectionsUsage()) {
            this.sectionsUsage.computeIfAbsent(section, q -> new LongAdder()).increment();
        }
        for (String query : searchUsage.getQueryUsage()) {
            this.queriesUsage.computeIfAbsent(query, q -> new LongAdder()).increment();
        }
        for (String rescorer : searchUsage.getRescorerUsage()) {
            this.rescorersUsage.computeIfAbsent(rescorer, q -> new LongAdder()).increment();
        }
        for (String retriever : searchUsage.getRetrieverUsage()) {
            this.retrieversUsage.computeIfAbsent(retriever, q -> new LongAdder()).increment();
        }
        this.updateExtendedUsage(searchUsage.getExtendedDataUsage());
    }

    public SearchUsageStats getSearchUsageStats() {
        Map queriesUsageMap = Maps.newMapWithExpectedSize(this.queriesUsage.size());
        this.queriesUsage.forEach((query, adder) -> queriesUsageMap.put(query, adder.longValue()));
        Map sectionsUsageMap = Maps.newMapWithExpectedSize(this.sectionsUsage.size());
        this.sectionsUsage.forEach((query, adder) -> sectionsUsageMap.put(query, adder.longValue()));
        Map rescorersUsageMap = Maps.newMapWithExpectedSize(this.rescorersUsage.size());
        this.rescorersUsage.forEach((query, adder) -> rescorersUsageMap.put(query, adder.longValue()));
        Map retrieversUsageMap = Maps.newMapWithExpectedSize(this.retrieversUsage.size());
        this.retrieversUsage.forEach((retriever, adder) -> retrieversUsageMap.put(retriever, adder.longValue()));
        ExtendedSearchUsageStats extendedSearchUsageStats = new ExtendedSearchUsageStats(this.getExtendedSearchUsage());
        return new SearchUsageStats(Collections.unmodifiableMap(queriesUsageMap), Collections.unmodifiableMap(rescorersUsageMap), Collections.unmodifiableMap(sectionsUsageMap), Collections.unmodifiableMap(retrieversUsageMap), extendedSearchUsageStats, this.totalSearchCount.longValue());
    }

    private Map<String, Map<String, ExtendedSearchUsageMetric<?>>> getExtendedSearchUsage() {
        return SearchUsageHolder.unmodifiableMap(this.extendedSearchUsage, nameMap -> SearchUsageHolder.unmodifiableMap(nameMap, valueMap -> new ExtendedSearchUsageLongCounter(SearchUsageHolder.unmodifiableMap(valueMap, LongAdder::longValue))));
    }

    private void updateExtendedUsage(Map<String, Map<String, Set<String>>> extendedDataUsage) {
        extendedDataUsage.forEach((category, nameMap) -> nameMap.forEach((name, valueSet) -> valueSet.forEach(value -> this.extendedSearchUsage.computeIfAbsent((String)category, k -> new ConcurrentHashMap()).computeIfAbsent(name, k -> new ConcurrentHashMap()).computeIfAbsent(value, k -> new LongAdder()).increment())));
    }

    private static <K, V, R> Map<K, R> unmodifiableMap(Map<K, V> in, Function<V, R> valueMapper) {
        HashMap map = new HashMap(in.size());
        in.forEach((k, v) -> map.put(k, valueMapper.apply(v)));
        return Collections.unmodifiableMap(map);
    }
}

