/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.admin.cluster.repositories.verify;

import java.io.IOException;
import org.elasticsearch.action.ActionRequestValidationException;
import org.elasticsearch.action.ValidateActions;
import org.elasticsearch.action.support.master.AcknowledgedRequest;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.core.TimeValue;

public class VerifyRepositoryRequest
extends AcknowledgedRequest<VerifyRepositoryRequest> {
    private String name;

    public VerifyRepositoryRequest(StreamInput in) throws IOException {
        super(in);
        this.name = in.readString();
    }

    public VerifyRepositoryRequest(TimeValue masterNodeTimeout, TimeValue ackTimeout) {
        super(masterNodeTimeout, ackTimeout);
    }

    public VerifyRepositoryRequest(TimeValue masterNodeTimeout, TimeValue ackTimeout, String name) {
        this(masterNodeTimeout, ackTimeout);
        this.name = name;
    }

    @Override
    public ActionRequestValidationException validate() {
        ActionRequestValidationException validationException = null;
        if (this.name == null) {
            validationException = ValidateActions.addValidationError("name is missing", validationException);
        }
        return validationException;
    }

    public VerifyRepositoryRequest name(String name) {
        this.name = name;
        return this;
    }

    public String name() {
        return this.name;
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        out.writeString(this.name);
    }
}

