/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.rollup.action;

import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.Executor;
import java.util.stream.Collectors;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.ActionListenerResponseHandler;
import org.elasticsearch.action.FailedNodeException;
import org.elasticsearch.action.TaskOperationFailure;
import org.elasticsearch.action.support.ActionFilters;
import org.elasticsearch.action.support.tasks.BaseTasksRequest;
import org.elasticsearch.action.support.tasks.TransportTasksAction;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.metadata.ProjectMetadata;
import org.elasticsearch.cluster.node.DiscoveryNodes;
import org.elasticsearch.cluster.project.ProjectResolver;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.logging.DeprecationCategory;
import org.elasticsearch.common.logging.DeprecationLogger;
import org.elasticsearch.common.util.concurrent.EsExecutors;
import org.elasticsearch.discovery.MasterNotDiscoveredException;
import org.elasticsearch.injection.guice.Inject;
import org.elasticsearch.persistent.PersistentTasksCustomMetadata;
import org.elasticsearch.tasks.CancellableTask;
import org.elasticsearch.tasks.Task;
import org.elasticsearch.transport.TransportRequest;
import org.elasticsearch.transport.TransportResponseHandler;
import org.elasticsearch.transport.TransportService;
import org.elasticsearch.xpack.core.rollup.action.GetRollupJobsAction;
import org.elasticsearch.xpack.core.rollup.job.RollupJobStatus;
import org.elasticsearch.xpack.rollup.action.TransportGetRollupCapsAction;
import org.elasticsearch.xpack.rollup.job.RollupJobTask;

public class TransportGetRollupJobAction
extends TransportTasksAction<RollupJobTask, GetRollupJobsAction.Request, GetRollupJobsAction.Response, GetRollupJobsAction.Response> {
    private static final DeprecationLogger DEPRECATION_LOGGER = DeprecationLogger.getLogger(TransportGetRollupCapsAction.class);
    private final ProjectResolver projectResolver;

    @Inject
    public TransportGetRollupJobAction(TransportService transportService, ActionFilters actionFilters, ClusterService clusterService, ProjectResolver projectResolver) {
        super("cluster:monitor/xpack/rollup/get", clusterService, transportService, actionFilters, GetRollupJobsAction.Request::new, GetRollupJobsAction.Response::new, (Executor)EsExecutors.DIRECT_EXECUTOR_SERVICE);
        this.projectResolver = projectResolver;
    }

    protected void doExecute(Task task, GetRollupJobsAction.Request request, ActionListener<GetRollupJobsAction.Response> listener) {
        DEPRECATION_LOGGER.warn(DeprecationCategory.API, "rollup_removal", "The rollup functionality will be removed in Elasticsearch 10.0. See docs for more information.", new Object[0]);
        ClusterState state = this.clusterService.state();
        DiscoveryNodes nodes = state.nodes();
        if (nodes.isLocalNodeElectedMaster()) {
            ProjectMetadata project = this.projectResolver.getProjectMetadata(state);
            if (TransportGetRollupJobAction.stateHasRollupJobs(request, project)) {
                super.doExecute(task, (BaseTasksRequest)request, listener);
            } else {
                listener.onResponse((Object)new GetRollupJobsAction.Response(Collections.emptyList()));
            }
        } else if (nodes.getMasterNode() == null) {
            listener.onFailure((Exception)new MasterNotDiscoveredException());
        } else {
            this.transportService.sendRequest(nodes.getMasterNode(), this.actionName, (TransportRequest)request, (TransportResponseHandler)new ActionListenerResponseHandler(listener, GetRollupJobsAction.Response::new, TransportResponseHandler.TRANSPORT_WORKER));
        }
    }

    static boolean stateHasRollupJobs(GetRollupJobsAction.Request request, ProjectMetadata project) {
        boolean hasRollupJobs = false;
        PersistentTasksCustomMetadata pTasksMeta = (PersistentTasksCustomMetadata)project.custom("persistent_tasks");
        if (pTasksMeta != null) {
            if (request.getId().equals("_all")) {
                hasRollupJobs = pTasksMeta.tasks().stream().anyMatch(persistentTask -> persistentTask.getTaskName().equals("xpack/rollup/job"));
            } else if (pTasksMeta.getTask(request.getId()) != null) {
                hasRollupJobs = true;
            }
        }
        return hasRollupJobs;
    }

    protected void taskOperation(CancellableTask actionTask, GetRollupJobsAction.Request request, RollupJobTask jobTask, ActionListener<GetRollupJobsAction.Response> listener) {
        List<Object> jobs = Collections.emptyList();
        assert (jobTask.getConfig().getId().equals(request.getId()) || request.getId().equals("_all"));
        if (!jobTask.isCancelled()) {
            GetRollupJobsAction.JobWrapper wrapper = new GetRollupJobsAction.JobWrapper(jobTask.getConfig(), jobTask.getStats(), (RollupJobStatus)jobTask.getStatus());
            jobs = Collections.singletonList(wrapper);
        }
        listener.onResponse((Object)new GetRollupJobsAction.Response(jobs));
    }

    protected GetRollupJobsAction.Response newResponse(GetRollupJobsAction.Request request, List<GetRollupJobsAction.Response> tasks, List<TaskOperationFailure> taskOperationFailures, List<FailedNodeException> failedNodeExceptions) {
        List jobs = tasks.stream().map(GetRollupJobsAction.Response::getJobs).flatMap(Collection::stream).collect(Collectors.toList());
        return new GetRollupJobsAction.Response(jobs, taskOperationFailures, failedNodeExceptions);
    }
}

