/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.esql.core.expression;

import java.io.IOException;
import java.util.List;
import java.util.Objects;
import org.elasticsearch.common.io.stream.NamedWriteable;
import org.elasticsearch.common.io.stream.NamedWriteableRegistry;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.xpack.esql.core.expression.Expression;
import org.elasticsearch.xpack.esql.core.expression.Nullability;
import org.elasticsearch.xpack.esql.core.tree.NodeInfo;
import org.elasticsearch.xpack.esql.core.tree.Source;
import org.elasticsearch.xpack.esql.core.type.DataType;
import org.elasticsearch.xpack.esql.core.util.PlanStreamInput;

public class EntryExpression
extends Expression {
    public static final NamedWriteableRegistry.Entry ENTRY = new NamedWriteableRegistry.Entry(Expression.class, "EntryExpression", EntryExpression::readFrom);
    private final Expression key;
    private final Expression value;

    public EntryExpression(Source source, Expression key, Expression value) {
        super(source, List.of(key, value));
        this.key = key;
        this.value = value;
    }

    private static EntryExpression readFrom(StreamInput in) throws IOException {
        return new EntryExpression(Source.readFrom((StreamInput)((PlanStreamInput)in)), (Expression)in.readNamedWriteable(Expression.class), (Expression)in.readNamedWriteable(Expression.class));
    }

    public void writeTo(StreamOutput out) throws IOException {
        this.source().writeTo(out);
        out.writeNamedWriteable((NamedWriteable)this.key);
        out.writeNamedWriteable((NamedWriteable)this.value);
    }

    public String getWriteableName() {
        return EntryExpression.ENTRY.name;
    }

    @Override
    public Expression replaceChildren(List<Expression> newChildren) {
        return new EntryExpression(this.source(), newChildren.get(0), newChildren.get(1));
    }

    @Override
    protected NodeInfo<? extends Expression> info() {
        return NodeInfo.create(this, EntryExpression::new, this.key, this.value);
    }

    public Expression key() {
        return this.key;
    }

    public Expression value() {
        return this.value;
    }

    @Override
    public DataType dataType() {
        return this.value.dataType();
    }

    @Override
    public Nullability nullable() {
        return Nullability.FALSE;
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.key, this.value);
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        EntryExpression other = (EntryExpression)obj;
        return Objects.equals(this.key, other.key) && Objects.equals(this.value, other.value);
    }

    @Override
    public String toString() {
        return this.key.toString() + ":" + this.value.toString();
    }
}

