/*
 * Decompiled with CFR 0.152.
 */
package org.ojalgo.random;

import org.ojalgo.function.constant.PrimitiveMath;
import org.ojalgo.random.RandomNumber;

public class Erlang
extends RandomNumber {
    private final int myCount;
    private final double myRate;

    public Erlang() {
        this((int)PrimitiveMath.ONE, PrimitiveMath.ONE);
    }

    public Erlang(int aCount, double aRate) {
        this.myCount = aCount;
        this.myRate = aRate;
    }

    @Override
    public double getExpected() {
        return (double)this.myCount / this.myRate;
    }

    @Override
    public double getVariance() {
        return (double)this.myCount / (this.myRate * this.myRate);
    }

    @Override
    protected double generate() {
        double tmpVal = PrimitiveMath.ZERO;
        for (int i = 0; i < this.myCount; ++i) {
            tmpVal -= PrimitiveMath.LOG.invoke(this.random().nextDouble());
        }
        return tmpVal / this.myRate;
    }
}

