/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.fleet.rest;

import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.function.IntConsumer;
import java.util.function.Predicate;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.ActionRequest;
import org.elasticsearch.action.search.SearchRequest;
import org.elasticsearch.action.search.TransportSearchAction;
import org.elasticsearch.client.internal.node.NodeClient;
import org.elasticsearch.common.Strings;
import org.elasticsearch.core.TimeValue;
import org.elasticsearch.features.NodeFeature;
import org.elasticsearch.rest.BaseRestHandler;
import org.elasticsearch.rest.RestHandler;
import org.elasticsearch.rest.RestRequest;
import org.elasticsearch.rest.Scope;
import org.elasticsearch.rest.ServerlessScope;
import org.elasticsearch.rest.action.RestCancellableNodeClient;
import org.elasticsearch.rest.action.RestRefCountedChunkedToXContentListener;
import org.elasticsearch.rest.action.search.RestSearchAction;
import org.elasticsearch.usage.SearchUsageHolder;
import org.elasticsearch.xcontent.XContentParser;

@ServerlessScope(value=Scope.INTERNAL)
public class RestFleetSearchAction
extends BaseRestHandler {
    private final SearchUsageHolder searchUsageHolder;
    private final Predicate<NodeFeature> clusterSupportsFeature;

    public RestFleetSearchAction(SearchUsageHolder searchUsageHolder, Predicate<NodeFeature> clusterSupportsFeature) {
        this.searchUsageHolder = searchUsageHolder;
        this.clusterSupportsFeature = clusterSupportsFeature;
    }

    public String getName() {
        return "fleet_search_action";
    }

    public List<RestHandler.Route> routes() {
        return List.of(new RestHandler.Route(RestRequest.Method.GET, "/{index}/_fleet/_fleet_search"), new RestHandler.Route(RestRequest.Method.POST, "/{index}/_fleet/_fleet_search"));
    }

    protected BaseRestHandler.RestChannelConsumer prepareRequest(RestRequest request, NodeClient client) throws IOException {
        SearchRequest searchRequest = new SearchRequest();
        request.param("min_compatible_shard_node");
        Object[] indices = searchRequest.indices();
        if (indices.length > 1) {
            throw new IllegalArgumentException("Fleet search API only supports searching a single index. Found: [" + Arrays.toString(indices) + "].");
        }
        IntConsumer setSize = size -> searchRequest.source().size(size);
        request.withContentOrSourceParamParserOrNull(parser -> {
            RestSearchAction.parseSearchRequest((SearchRequest)searchRequest, (RestRequest)request, (XContentParser)parser, this.clusterSupportsFeature, (IntConsumer)setSize, (SearchUsageHolder)this.searchUsageHolder);
            String[] stringWaitForCheckpoints = request.paramAsStringArray("wait_for_checkpoints", Strings.EMPTY_ARRAY);
            long[] waitForCheckpoints = new long[stringWaitForCheckpoints.length];
            for (int i = 0; i < stringWaitForCheckpoints.length; ++i) {
                waitForCheckpoints[i] = Long.parseLong(stringWaitForCheckpoints[i]);
            }
            Object[] indices1 = Strings.splitStringByCommaToArray((String)request.param("index"));
            if (indices1.length > 1) {
                throw new IllegalArgumentException("Fleet search API only supports searching a single index. Found: [" + Arrays.toString(indices1) + "].");
            }
            if (waitForCheckpoints.length != 0) {
                searchRequest.setWaitForCheckpoints(Collections.singletonMap(indices1[0], waitForCheckpoints));
            }
            TimeValue waitForCheckpointsTimeout = request.paramAsTime("wait_for_checkpoints_timeout", TimeValue.timeValueSeconds((long)30L));
            searchRequest.setWaitForCheckpointsTimeout(waitForCheckpointsTimeout);
        });
        return channel -> {
            RestCancellableNodeClient cancelClient = new RestCancellableNodeClient(client, request.getHttpChannel());
            cancelClient.execute(TransportSearchAction.TYPE, (ActionRequest)searchRequest, (ActionListener)new RestRefCountedChunkedToXContentListener(channel));
        };
    }

    protected Set<String> responseParams() {
        return RestSearchAction.RESPONSE_PARAMS;
    }
}

