/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.apm.agent.premain;

import co.elastic.apm.agent.premain.BootstrapCheck;
import javax.annotation.Nullable;

public class JvmToolBootstrapCheck
implements BootstrapCheck {
    @Nullable
    private final String cmd;

    public JvmToolBootstrapCheck(String jvmCmd) {
        this.cmd = jvmCmd;
    }

    @Override
    public void doBootstrapCheck(BootstrapCheck.BootstrapCheckResult result) {
        JvmToolBootstrapCheck.checkJdkTool(this.cmd, result);
    }

    public static void checkJdkTool(String jvmCmd, BootstrapCheck.BootstrapCheckResult result) {
        if (jvmCmd == null) {
            return;
        }
        String[] parts = jvmCmd.split(" ");
        if (parts.length > 0 && parts[0].endsWith(".jar")) {
            return;
        }
        boolean isJdkTool = false;
        parts = jvmCmd.split("/");
        if (parts.length == 2) {
            isJdkTool = parts[0].startsWith("jdk.") || parts[0].startsWith("java.");
        } else if (parts.length == 1) {
            isJdkTool = jvmCmd.startsWith("sun.") || jvmCmd.startsWith("com.sun.") || jvmCmd.startsWith("jdk.");
        } else {
            result.addWarn("Unexpected JVM command line syntax: " + jvmCmd);
        }
        if (isJdkTool) {
            result.addError(String.format("JVM tool detected: '%s', agent instrumentation on JVM tools adds unnecessary performance overhead", jvmCmd));
        }
    }
}

