/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.apm.agent.premain;

import co.elastic.apm.agent.premain.AgentJarLocator;
import co.elastic.apm.agent.premain.BootstrapCheck;
import co.elastic.apm.agent.premain.common.JvmRuntimeInfo;
import java.util.jar.JarFile;
import java.util.jar.Manifest;

public class JavaVersionBootstrapCheck
implements BootstrapCheck {
    private final JvmRuntimeInfo runtimeInfo;

    public JavaVersionBootstrapCheck(JvmRuntimeInfo runtimeInfo) {
        this.runtimeInfo = runtimeInfo;
    }

    @Override
    public void doBootstrapCheck(BootstrapCheck.BootstrapCheckResult result) {
        if (!this.isJavaVersionSupported()) {
            result.addError(String.format("JVM version not supported: %s", this.runtimeInfo));
        } else if (this.isJavaVersionDeprecated()) {
            result.addWarn(String.format("Java %s support is deprecated and will be removed in a future version", this.runtimeInfo.getMajorVersion()));
        }
    }

    public boolean isJavaVersionSupported() {
        if (this.runtimeInfo.getMajorVersion() < this.getMinSupportedMajorJavaVersion()) {
            return false;
        }
        if (this.runtimeInfo.isHotSpot()) {
            return this.isHotSpotVersionSupported();
        }
        if (this.runtimeInfo.isIbmJ9()) {
            return this.isIbmJ9VersionSupported();
        }
        return true;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private int getMinSupportedMajorJavaVersion() {
        try (JarFile jarFile = new JarFile(AgentJarLocator.getAgentJarFile());){
            Manifest manifest = jarFile.getManifest();
            String variant = manifest.getMainAttributes().getValue("Elastic-Apm-Build-Variant");
            if (!"java8".equals(variant)) return 7;
            int n = 8;
            return n;
        }
        catch (Exception exception) {
            // empty catch block
        }
        return 7;
    }

    private boolean isJavaVersionDeprecated() {
        return this.runtimeInfo.getMajorVersion() == 7;
    }

    private boolean isHotSpotVersionSupported() {
        int updateVersion = this.runtimeInfo.getUpdateVersion();
        int majorVersion = this.runtimeInfo.getMajorVersion();
        if (updateVersion < 0) {
            return true;
        }
        int java7min = 60;
        int java8min = 40;
        if (this.runtimeInfo.isHpUx()) {
            java7min = 10;
            java8min = 2;
        }
        switch (majorVersion) {
            case 7: {
                return updateVersion >= java7min;
            }
            case 8: {
                return updateVersion >= java8min;
            }
        }
        return true;
    }

    private boolean isIbmJ9VersionSupported() {
        switch (this.runtimeInfo.getMajorVersion()) {
            case 7: {
                return false;
            }
            case 8: {
                return !"2.8".equals(this.runtimeInfo.getJavaVmVersion());
            }
        }
        return true;
    }
}

