/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.inference.services.azureaistudio.rerank;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.elasticsearch.TransportVersion;
import org.elasticsearch.common.ValidationException;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.inference.TaskSettings;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.XContentBuilder;
import org.elasticsearch.xpack.inference.services.ServiceUtils;
import org.elasticsearch.xpack.inference.services.azureaistudio.rerank.AzureAiStudioRerankRequestTaskSettings;

public class AzureAiStudioRerankTaskSettings
implements TaskSettings {
    public static final String NAME = "azure_ai_studio_rerank_task_settings";
    private static final TransportVersion ML_INFERENCE_AZURE_AI_STUDIO_RERANK_ADDED = TransportVersion.fromName((String)"ml_inference_azure_ai_studio_rerank_added");
    private final Boolean returnDocuments;
    private final Integer topN;

    public static AzureAiStudioRerankTaskSettings fromMap(Map<String, Object> map) {
        ValidationException validationException = new ValidationException();
        Boolean returnDocuments = ServiceUtils.extractOptionalBoolean(map, "return_documents", validationException);
        Integer topN = ServiceUtils.extractOptionalPositiveInteger(map, "top_n", "task_settings", validationException);
        if (!validationException.validationErrors().isEmpty()) {
            throw validationException;
        }
        return new AzureAiStudioRerankTaskSettings(returnDocuments, topN);
    }

    public static AzureAiStudioRerankTaskSettings of(AzureAiStudioRerankTaskSettings originalSettings, AzureAiStudioRerankRequestTaskSettings requestSettings) {
        Boolean returnDocuments = requestSettings.returnDocuments() == null ? originalSettings.returnDocuments() : requestSettings.returnDocuments();
        Integer topN = requestSettings.topN() == null ? originalSettings.topN() : requestSettings.topN();
        return new AzureAiStudioRerankTaskSettings(returnDocuments, topN);
    }

    public AzureAiStudioRerankTaskSettings(@Nullable Boolean returnDocuments, @Nullable Integer topN) {
        this.returnDocuments = returnDocuments;
        this.topN = topN;
    }

    public AzureAiStudioRerankTaskSettings(StreamInput in) throws IOException {
        this.returnDocuments = in.readOptionalBoolean();
        this.topN = in.readOptionalVInt();
    }

    public Boolean returnDocuments() {
        return this.returnDocuments;
    }

    public Integer topN() {
        return this.topN;
    }

    public String getWriteableName() {
        return NAME;
    }

    public TransportVersion getMinimalSupportedVersion() {
        return ML_INFERENCE_AZURE_AI_STUDIO_RERANK_ADDED;
    }

    public boolean isEmpty() {
        return this.returnDocuments == null && this.topN == null;
    }

    public void writeTo(StreamOutput out) throws IOException {
        out.writeOptionalBoolean(this.returnDocuments);
        out.writeOptionalVInt(this.topN);
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        if (this.returnDocuments != null) {
            builder.field("return_documents", this.returnDocuments);
        }
        if (this.topN != null) {
            builder.field("top_n", this.topN);
        }
        builder.endObject();
        return builder;
    }

    public String toString() {
        return "AzureAiStudioRerankTaskSettings{, returnDocuments=" + this.returnDocuments + ", topN=" + this.topN + "}";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AzureAiStudioRerankTaskSettings that = (AzureAiStudioRerankTaskSettings)o;
        return Objects.equals(this.returnDocuments, that.returnDocuments) && Objects.equals(this.topN, that.topN);
    }

    public int hashCode() {
        return Objects.hash(this.returnDocuments, this.topN);
    }

    public TaskSettings updatedTaskSettings(Map<String, Object> newSettings) {
        AzureAiStudioRerankRequestTaskSettings requestSettings = AzureAiStudioRerankRequestTaskSettings.fromMap(new HashMap<String, Object>(newSettings));
        return AzureAiStudioRerankTaskSettings.of(this, requestSettings);
    }
}

