/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.inference.services.amazonbedrock.client;

import java.io.IOException;
import java.time.Clock;
import java.util.Objects;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.ElasticsearchException;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.core.TimeValue;
import org.elasticsearch.inference.InferenceServiceResults;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.xpack.inference.external.http.retry.ResponseHandler;
import org.elasticsearch.xpack.inference.external.http.sender.InferenceInputs;
import org.elasticsearch.xpack.inference.external.http.sender.RequestExecutorServiceSettings;
import org.elasticsearch.xpack.inference.external.http.sender.RequestManager;
import org.elasticsearch.xpack.inference.external.http.sender.Sender;
import org.elasticsearch.xpack.inference.external.request.Request;
import org.elasticsearch.xpack.inference.services.ServiceComponents;
import org.elasticsearch.xpack.inference.services.amazonbedrock.AmazonBedrockRequestExecutorService;
import org.elasticsearch.xpack.inference.services.amazonbedrock.AmazonBedrockRequestManager;
import org.elasticsearch.xpack.inference.services.amazonbedrock.client.AmazonBedrockExecuteOnlyRequestSender;
import org.elasticsearch.xpack.inference.services.amazonbedrock.client.AmazonBedrockInferenceClient;
import org.elasticsearch.xpack.inference.services.amazonbedrock.client.AmazonBedrockInferenceClientCache;

public class AmazonBedrockRequestSender
implements Sender {
    private static final TimeValue START_COMPLETED_WAIT_TIME = TimeValue.timeValueSeconds((long)5L);
    private final ThreadPool threadPool;
    private final AmazonBedrockRequestExecutorService executorService;
    private final AtomicBoolean started = new AtomicBoolean(false);
    private final CountDownLatch startCompleted;

    protected AmazonBedrockRequestSender(ThreadPool threadPool, AmazonBedrockRequestExecutorService executorService, CountDownLatch startCompleted) {
        this.threadPool = Objects.requireNonNull(threadPool);
        this.executorService = Objects.requireNonNull(executorService);
        this.startCompleted = Objects.requireNonNull(startCompleted);
    }

    @Override
    public void startAsynchronously(ActionListener<Void> listener) {
        throw new UnsupportedOperationException("not implemented");
    }

    @Override
    public void startSynchronously() {
        if (this.started.compareAndSet(false, true)) {
            this.threadPool.executor("inference_utility").execute(this.executorService::start);
            this.waitForStartToComplete();
        }
    }

    private void waitForStartToComplete() {
        try {
            if (!this.startCompleted.await(START_COMPLETED_WAIT_TIME.getSeconds(), TimeUnit.SECONDS)) {
                throw new IllegalStateException("Amazon Bedrock sender startup did not complete in time");
            }
        }
        catch (InterruptedException e) {
            throw new IllegalStateException("Amazon Bedrock sender interrupted while waiting for startup to complete");
        }
    }

    @Override
    public void send(RequestManager requestCreator, InferenceInputs inferenceInputs, TimeValue timeout, ActionListener<InferenceServiceResults> listener) {
        assert (this.started.get()) : "Amazon Bedrock request sender: call start() before sending a request";
        this.waitForStartToComplete();
        if (requestCreator instanceof AmazonBedrockRequestManager) {
            AmazonBedrockRequestManager amazonBedrockRequestManager = (AmazonBedrockRequestManager)requestCreator;
            this.executorService.execute(amazonBedrockRequestManager, inferenceInputs, timeout, listener);
            return;
        }
        listener.onFailure((Exception)new ElasticsearchException("Amazon Bedrock request sender did not receive a valid request request manager", new Object[0]));
    }

    @Override
    public void sendWithoutQueuing(Logger logger, Request request, ResponseHandler responseHandler, TimeValue timeout, ActionListener<InferenceServiceResults> listener) {
        throw new UnsupportedOperationException("not implemented");
    }

    @Override
    public void close() throws IOException {
        this.executorService.shutdown();
    }

    public static class Factory {
        private final ServiceComponents serviceComponents;
        private final AmazonBedrockRequestExecutorService executorService;
        private final CountDownLatch startCompleted = new CountDownLatch(1);
        private final AmazonBedrockRequestSender bedrockRequestSender;

        public Factory(ServiceComponents serviceComponents, ClusterService clusterService) {
            this(serviceComponents, clusterService, new AmazonBedrockExecuteOnlyRequestSender(new AmazonBedrockInferenceClientCache((model, timeout) -> AmazonBedrockInferenceClient.create(model, timeout, serviceComponents.threadPool()), Clock.systemUTC()), serviceComponents.throttlerManager()));
        }

        public Factory(ServiceComponents serviceComponents, ClusterService clusterService, AmazonBedrockExecuteOnlyRequestSender requestSender) {
            this.serviceComponents = Objects.requireNonNull(serviceComponents);
            Objects.requireNonNull(clusterService);
            this.executorService = new AmazonBedrockRequestExecutorService(serviceComponents.threadPool(), this.startCompleted, new RequestExecutorServiceSettings(serviceComponents.settings(), clusterService), requestSender);
            this.bedrockRequestSender = new AmazonBedrockRequestSender(serviceComponents.threadPool(), this.executorService, this.startCompleted);
        }

        public Sender createSender() {
            this.bedrockRequestSender.startSynchronously();
            return this.bedrockRequestSender;
        }
    }
}

