/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.inference.services.alibabacloudsearch.request;

import java.net.URI;
import java.net.URISyntaxException;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.Objects;
import org.apache.http.HttpEntity;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.client.utils.URIBuilder;
import org.apache.http.entity.ByteArrayEntity;
import org.elasticsearch.common.CheckedSupplier;
import org.elasticsearch.common.Strings;
import org.elasticsearch.inference.InputType;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.XContentType;
import org.elasticsearch.xpack.inference.external.request.HttpRequest;
import org.elasticsearch.xpack.inference.external.request.Request;
import org.elasticsearch.xpack.inference.external.request.RequestUtils;
import org.elasticsearch.xpack.inference.services.alibabacloudsearch.AlibabaCloudSearchAccount;
import org.elasticsearch.xpack.inference.services.alibabacloudsearch.embeddings.AlibabaCloudSearchEmbeddingsModel;
import org.elasticsearch.xpack.inference.services.alibabacloudsearch.embeddings.AlibabaCloudSearchEmbeddingsTaskSettings;
import org.elasticsearch.xpack.inference.services.alibabacloudsearch.request.AlibabaCloudSearchEmbeddingsRequestEntity;
import org.elasticsearch.xpack.inference.services.alibabacloudsearch.request.AlibabaCloudSearchRequest;

public class AlibabaCloudSearchEmbeddingsRequest
extends AlibabaCloudSearchRequest {
    private final AlibabaCloudSearchAccount account;
    private final List<String> input;
    private final InputType inputType;
    private final URI uri;
    private final AlibabaCloudSearchEmbeddingsTaskSettings taskSettings;
    private final String model;
    private final String host;
    private final String workspaceName;
    private final String httpSchema;
    private final String inferenceEntityId;

    public AlibabaCloudSearchEmbeddingsRequest(AlibabaCloudSearchAccount account, List<String> input, InputType inputType, AlibabaCloudSearchEmbeddingsModel embeddingsModel) {
        Objects.requireNonNull(embeddingsModel);
        this.account = Objects.requireNonNull(account);
        this.input = Objects.requireNonNull(input);
        this.inputType = inputType;
        this.taskSettings = embeddingsModel.getTaskSettings();
        this.model = embeddingsModel.getServiceSettings().getCommonSettings().modelId();
        this.host = embeddingsModel.getServiceSettings().getCommonSettings().getHost();
        this.workspaceName = embeddingsModel.getServiceSettings().getCommonSettings().getWorkspaceName();
        this.httpSchema = embeddingsModel.getServiceSettings().getCommonSettings().getHttpSchema() != null ? embeddingsModel.getServiceSettings().getCommonSettings().getHttpSchema() : "https";
        this.uri = RequestUtils.buildUri(null, "alibabacloud-ai-search", (CheckedSupplier<URI, URISyntaxException>)((CheckedSupplier)this::buildDefaultUri));
        this.inferenceEntityId = embeddingsModel.getInferenceEntityId();
    }

    @Override
    public HttpRequest createHttpRequest() {
        HttpPost httpPost = new HttpPost(this.uri);
        ByteArrayEntity byteEntity = new ByteArrayEntity(Strings.toString((ToXContent)new AlibabaCloudSearchEmbeddingsRequestEntity(this.input, this.inputType, this.taskSettings)).getBytes(StandardCharsets.UTF_8));
        httpPost.setEntity((HttpEntity)byteEntity);
        httpPost.setHeader("Content-Type", XContentType.JSON.mediaType());
        httpPost.setHeader(RequestUtils.createAuthBearerHeader(this.account.apiKey()));
        return new HttpRequest((HttpRequestBase)httpPost, this.getInferenceEntityId());
    }

    @Override
    public String getInferenceEntityId() {
        return this.inferenceEntityId;
    }

    @Override
    public URI getURI() {
        return this.uri;
    }

    @Override
    public Request truncate() {
        return this;
    }

    @Override
    public boolean[] getTruncationInfo() {
        return null;
    }

    URI buildDefaultUri() throws URISyntaxException {
        return new URIBuilder().setScheme(this.httpSchema).setHost(this.host).setPathSegments(new String[]{"v3", "openapi", "workspaces", this.workspaceName, "text-embedding", this.model}).build();
    }
}

