/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.inference.action;

import java.util.Optional;
import java.util.concurrent.Executor;
import org.elasticsearch.ElasticsearchStatusException;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.support.ActionFilters;
import org.elasticsearch.action.support.HandledTransportAction;
import org.elasticsearch.action.support.SubscribableListener;
import org.elasticsearch.common.util.concurrent.EsExecutors;
import org.elasticsearch.inference.InferenceService;
import org.elasticsearch.inference.InferenceServiceRegistry;
import org.elasticsearch.inference.Model;
import org.elasticsearch.inference.RerankingInferenceService;
import org.elasticsearch.inference.TaskType;
import org.elasticsearch.inference.UnparsedModel;
import org.elasticsearch.injection.guice.Inject;
import org.elasticsearch.rest.RestStatus;
import org.elasticsearch.tasks.Task;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.TransportService;
import org.elasticsearch.xpack.core.inference.action.GetRerankerWindowSizeAction;
import org.elasticsearch.xpack.inference.registry.ModelRegistry;

public class TransportGetRerankerWindowSizeAction
extends HandledTransportAction<GetRerankerWindowSizeAction.Request, GetRerankerWindowSizeAction.Response> {
    private final ModelRegistry modelRegistry;
    private final InferenceServiceRegistry serviceRegistry;

    @Inject
    public TransportGetRerankerWindowSizeAction(TransportService transportService, ActionFilters actionFilters, ThreadPool threadPool, ModelRegistry modelRegistry, InferenceServiceRegistry serviceRegistry) {
        super("cluster:internal/xpack/inference/rerankwindowsize/get", transportService, actionFilters, GetRerankerWindowSizeAction.Request::new, (Executor)EsExecutors.DIRECT_EXECUTOR_SERVICE);
        this.modelRegistry = modelRegistry;
        this.serviceRegistry = serviceRegistry;
    }

    protected void doExecute(Task task, GetRerankerWindowSizeAction.Request request, ActionListener<GetRerankerWindowSizeAction.Response> listener) {
        SubscribableListener.newForked(l -> this.modelRegistry.getModel(request.getInferenceEntityId(), (ActionListener<UnparsedModel>)l)).andThen((l, unparsedModel) -> {
            if (unparsedModel.taskType() != TaskType.RERANK) {
                throw new ElasticsearchStatusException("Inference endpoint [{}] does not have the {} task type", RestStatus.BAD_REQUEST, new Object[]{request.getInferenceEntityId(), TaskType.RERANK});
            }
            Optional service = this.serviceRegistry.getService(unparsedModel.service());
            if (service.isEmpty()) {
                throw new ElasticsearchStatusException("Unknown service [{}] for inference endpoint [{}]", RestStatus.BAD_REQUEST, new Object[]{unparsedModel.service(), request.getInferenceEntityId()});
            }
            Object patt0$temp = service.get();
            if (!(patt0$temp instanceof RerankingInferenceService)) {
                throw new IllegalStateException("Inference endpoint [" + request.getInferenceEntityId() + "] has task type [" + String.valueOf(TaskType.RERANK) + "] but the service [" + ((InferenceService)service.get()).name() + "] does not support reranking");
            }
            RerankingInferenceService rerankingInferenceService = (RerankingInferenceService)patt0$temp;
            Model model = ((InferenceService)service.get()).parsePersistedConfig(unparsedModel.inferenceEntityId(), unparsedModel.taskType(), unparsedModel.settings());
            l.onResponse((Object)new GetRerankerWindowSizeAction.Response(this.rerankWindowSize(rerankingInferenceService, model.getServiceSettings().modelId())));
        }).addListener(listener);
    }

    private int rerankWindowSize(RerankingInferenceService service, String modelId) {
        return service.rerankerWindowSize(modelId);
    }
}

