/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.idp.saml.rest.action;

import java.io.IOException;
import java.util.List;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.ActionRequest;
import org.elasticsearch.action.ActionType;
import org.elasticsearch.action.support.WriteRequest;
import org.elasticsearch.client.internal.node.NodeClient;
import org.elasticsearch.license.XPackLicenseState;
import org.elasticsearch.rest.BaseRestHandler;
import org.elasticsearch.rest.RestHandler;
import org.elasticsearch.rest.RestRequest;
import org.elasticsearch.rest.RestResponse;
import org.elasticsearch.rest.RestStatus;
import org.elasticsearch.rest.action.RestBuilderListener;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.XContentBuilder;
import org.elasticsearch.xpack.idp.action.DeleteSamlServiceProviderAction;
import org.elasticsearch.xpack.idp.action.DeleteSamlServiceProviderRequest;
import org.elasticsearch.xpack.idp.action.DeleteSamlServiceProviderResponse;
import org.elasticsearch.xpack.idp.saml.rest.action.IdpBaseRestHandler;

public class RestDeleteSamlServiceProviderAction
extends IdpBaseRestHandler {
    public RestDeleteSamlServiceProviderAction(XPackLicenseState licenseState) {
        super(licenseState);
    }

    public String getName() {
        return "idp_delete_saml_sp_action";
    }

    public List<RestHandler.Route> routes() {
        return List.of(new RestHandler.Route(RestRequest.Method.DELETE, "/_idp/saml/sp/{sp_entity_id}"));
    }

    @Override
    protected BaseRestHandler.RestChannelConsumer innerPrepareRequest(final RestRequest restRequest, NodeClient client) throws IOException {
        String entityId = restRequest.param("sp_entity_id");
        WriteRequest.RefreshPolicy refresh = restRequest.hasParam("refresh") ? WriteRequest.RefreshPolicy.parse((String)restRequest.param("refresh")) : WriteRequest.RefreshPolicy.NONE;
        DeleteSamlServiceProviderRequest request = new DeleteSamlServiceProviderRequest(entityId, refresh);
        return channel -> client.execute((ActionType)DeleteSamlServiceProviderAction.INSTANCE, (ActionRequest)request, (ActionListener)new RestBuilderListener<DeleteSamlServiceProviderResponse>(this, channel){

            public RestResponse buildResponse(DeleteSamlServiceProviderResponse response, XContentBuilder builder) throws Exception {
                response.toXContent(builder, (ToXContent.Params)restRequest);
                return new RestResponse(response.found() ? RestStatus.OK : RestStatus.NOT_FOUND, builder);
            }
        });
    }
}

