/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.telemetry.apm;

import io.opentelemetry.api.metrics.Meter;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Function;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.telemetry.apm.internal.MetricNameValidator;
import org.elasticsearch.telemetry.metric.Instrument;

public abstract class AbstractInstrument<T>
implements Instrument {
    private final AtomicReference<T> delegate = new AtomicReference();
    private final String name;
    private final Function<Meter, T> instrumentBuilder;

    public AbstractInstrument(Meter meter, Builder<T> builder) {
        this.name = builder.getName();
        this.instrumentBuilder = m -> builder.build((Meter)m);
        this.delegate.set(this.instrumentBuilder.apply(meter));
    }

    public String getName() {
        return this.name;
    }

    protected T getInstrument() {
        return this.delegate.get();
    }

    void setProvider(@Nullable Meter meter) {
        this.delegate.set(this.instrumentBuilder.apply(Objects.requireNonNull(meter)));
    }

    protected static abstract class Builder<T> {
        protected final String name;
        protected final String description;
        protected final String unit;

        public Builder(String name, String description, String unit) {
            this.name = MetricNameValidator.validate(name);
            this.description = Objects.requireNonNull(description);
            this.unit = Objects.requireNonNull(unit);
        }

        public String getName() {
            return this.name;
        }

        public abstract T build(Meter var1);
    }
}

