/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.analysis.common;

import java.io.IOException;
import org.apache.lucene.analysis.CharArraySet;
import org.apache.lucene.analysis.FilteringTokenFilter;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.tokenattributes.CharTermAttribute;
import org.apache.lucene.analysis.tokenattributes.PositionIncrementAttribute;

class UniqueTokenFilter
extends FilteringTokenFilter {
    private final CharTermAttribute termAttribute = (CharTermAttribute)this.addAttribute(CharTermAttribute.class);
    private final PositionIncrementAttribute posIncAttribute = (PositionIncrementAttribute)this.addAttribute(PositionIncrementAttribute.class);
    private final CharArraySet previous = new CharArraySet(8, false);
    private final boolean onlyOnSamePosition;

    UniqueTokenFilter(TokenStream in) {
        this(in, false);
    }

    UniqueTokenFilter(TokenStream in, boolean onlyOnSamePosition) {
        super(in);
        this.onlyOnSamePosition = onlyOnSamePosition;
    }

    protected boolean accept() {
        boolean duplicate;
        char[] term = this.termAttribute.buffer();
        int length = this.termAttribute.length();
        int posIncrement = this.posIncAttribute.getPositionIncrement();
        if (this.onlyOnSamePosition) {
            if (posIncrement > 0) {
                this.previous.clear();
            }
            duplicate = posIncrement == 0 && this.previous.contains(term, 0, length);
        } else {
            duplicate = this.previous.contains(term, 0, length);
        }
        char[] saved = new char[length];
        System.arraycopy(term, 0, saved, 0, length);
        this.previous.add(saved);
        return !duplicate;
    }

    public final void reset() throws IOException {
        super.reset();
        this.previous.clear();
    }
}

