/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.ilm.action;

import java.util.concurrent.Executor;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.lucene.util.SetOnce;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.support.ActionFilters;
import org.elasticsearch.action.support.master.TransportMasterNodeAction;
import org.elasticsearch.client.internal.Client;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.ClusterStateUpdateTask;
import org.elasticsearch.cluster.block.ClusterBlockException;
import org.elasticsearch.cluster.block.ClusterBlockLevel;
import org.elasticsearch.cluster.metadata.ProjectId;
import org.elasticsearch.cluster.metadata.ProjectMetadata;
import org.elasticsearch.cluster.project.ProjectResolver;
import org.elasticsearch.cluster.routing.RerouteService;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.cluster.service.MasterService;
import org.elasticsearch.common.Priority;
import org.elasticsearch.common.util.concurrent.EsExecutors;
import org.elasticsearch.core.SuppressForbidden;
import org.elasticsearch.core.Tuple;
import org.elasticsearch.injection.guice.Inject;
import org.elasticsearch.license.XPackLicenseState;
import org.elasticsearch.tasks.Task;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.TransportService;
import org.elasticsearch.xcontent.NamedXContentRegistry;
import org.elasticsearch.xpack.cluster.action.MigrateToDataTiersRequest;
import org.elasticsearch.xpack.cluster.action.MigrateToDataTiersResponse;
import org.elasticsearch.xpack.cluster.metadata.MetadataMigrateToDataTiersRoutingService;
import org.elasticsearch.xpack.core.ilm.IndexLifecycleMetadata;
import org.elasticsearch.xpack.core.ilm.LifecycleOperationMetadata;
import org.elasticsearch.xpack.core.ilm.OperationMode;

public class TransportMigrateToDataTiersAction
extends TransportMasterNodeAction<MigrateToDataTiersRequest, MigrateToDataTiersResponse> {
    private static final Logger logger = LogManager.getLogger(TransportMigrateToDataTiersAction.class);
    private final RerouteService rerouteService;
    private final NamedXContentRegistry xContentRegistry;
    private final Client client;
    private final XPackLicenseState licenseState;
    private final ProjectResolver projectResolver;

    @Inject
    public TransportMigrateToDataTiersAction(TransportService transportService, ClusterService clusterService, RerouteService rerouteService, ThreadPool threadPool, ActionFilters actionFilters, NamedXContentRegistry xContentRegistry, Client client, XPackLicenseState licenseState, ProjectResolver projectResolver) {
        super("cluster:admin/migrate_to_data_tiers", transportService, clusterService, threadPool, actionFilters, MigrateToDataTiersRequest::new, MigrateToDataTiersResponse::new, (Executor)EsExecutors.DIRECT_EXECUTOR_SERVICE);
        this.rerouteService = rerouteService;
        this.xContentRegistry = xContentRegistry;
        this.client = client;
        this.licenseState = licenseState;
        this.projectResolver = projectResolver;
    }

    protected void masterOperation(Task task, final MigrateToDataTiersRequest request, ClusterState state, final ActionListener<MigrateToDataTiersResponse> listener) throws Exception {
        final ProjectId projectId = this.projectResolver.getProjectId();
        if (request.isDryRun()) {
            MetadataMigrateToDataTiersRoutingService.MigratedEntities entities = (MetadataMigrateToDataTiersRoutingService.MigratedEntities)MetadataMigrateToDataTiersRoutingService.migrateToDataTiersRouting(state.projectState(projectId), request.getNodeAttributeName(), request.getLegacyTemplateToDelete(), this.xContentRegistry, this.client, this.licenseState, request.isDryRun()).v2();
            listener.onResponse((Object)new MigrateToDataTiersResponse(entities.removedIndexTemplateName(), entities.migratedPolicies(), entities.migratedIndices(), entities.migratedTemplates().migratedLegacyTemplates(), entities.migratedTemplates().migratedComposableTemplates(), entities.migratedTemplates().migratedComponentTemplates(), true));
            return;
        }
        ProjectMetadata projectMetadata = this.projectResolver.getProjectMetadata(state);
        IndexLifecycleMetadata currentMetadata = (IndexLifecycleMetadata)projectMetadata.custom("index_lifecycle");
        if (currentMetadata != null && LifecycleOperationMetadata.currentILMMode((ProjectMetadata)projectMetadata) != OperationMode.STOPPED) {
            listener.onFailure((Exception)new IllegalStateException("stop ILM before migrating to data tiers, current state is [" + String.valueOf(LifecycleOperationMetadata.currentILMMode((ProjectMetadata)projectMetadata)) + "]"));
            return;
        }
        final SetOnce migratedEntities = new SetOnce();
        this.submitUnbatchedTask("migrate-to-data-tiers []", new ClusterStateUpdateTask(Priority.HIGH){

            public ClusterState execute(ClusterState currentState) {
                Tuple<ClusterState, MetadataMigrateToDataTiersRoutingService.MigratedEntities> migratedEntitiesTuple = MetadataMigrateToDataTiersRoutingService.migrateToDataTiersRouting(currentState.projectState(projectId), request.getNodeAttributeName(), request.getLegacyTemplateToDelete(), TransportMigrateToDataTiersAction.this.xContentRegistry, TransportMigrateToDataTiersAction.this.client, TransportMigrateToDataTiersAction.this.licenseState, request.isDryRun());
                migratedEntities.set((Object)((MetadataMigrateToDataTiersRoutingService.MigratedEntities)migratedEntitiesTuple.v2()));
                return (ClusterState)migratedEntitiesTuple.v1();
            }

            public void onFailure(Exception e) {
                listener.onFailure(e);
            }

            public void clusterStateProcessed(ClusterState oldState, ClusterState newState) {
                TransportMigrateToDataTiersAction.this.rerouteService.reroute("cluster migrated to data tiers routing", Priority.NORMAL, (ActionListener)new ActionListener<Void>(this){

                    public void onResponse(Void ignored) {
                    }

                    public void onFailure(Exception e) {
                        logger.log(MasterService.isPublishFailureException((Exception)e) ? Level.DEBUG : Level.WARN, "unsuccessful reroute after migration to data tiers routing", (Throwable)e);
                    }
                });
                MetadataMigrateToDataTiersRoutingService.MigratedEntities entities = (MetadataMigrateToDataTiersRoutingService.MigratedEntities)migratedEntities.get();
                listener.onResponse((Object)new MigrateToDataTiersResponse(entities.removedIndexTemplateName(), entities.migratedPolicies(), entities.migratedIndices(), entities.migratedTemplates().migratedLegacyTemplates(), entities.migratedTemplates().migratedComposableTemplates(), entities.migratedTemplates().migratedComponentTemplates(), false));
            }
        });
    }

    @SuppressForbidden(reason="legacy usage of unbatched task")
    private void submitUnbatchedTask(String source, ClusterStateUpdateTask task) {
        this.clusterService.submitUnbatchedStateUpdateTask(source, task);
    }

    protected ClusterBlockException checkBlock(MigrateToDataTiersRequest request, ClusterState state) {
        return state.blocks().globalBlockedException(ClusterBlockLevel.METADATA_WRITE);
    }
}

