/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.ilm.action;

import java.io.IOException;
import java.util.List;
import java.util.Set;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.ActionRequest;
import org.elasticsearch.client.internal.node.NodeClient;
import org.elasticsearch.rest.BaseRestHandler;
import org.elasticsearch.rest.RestHandler;
import org.elasticsearch.rest.RestRequest;
import org.elasticsearch.rest.RestUtils;
import org.elasticsearch.rest.action.RestToXContentListener;
import org.elasticsearch.xcontent.XContentParser;
import org.elasticsearch.xpack.core.ilm.LifecyclePolicy;
import org.elasticsearch.xpack.core.ilm.action.ILMActions;
import org.elasticsearch.xpack.core.ilm.action.PutLifecycleRequest;

public class RestPutLifecycleAction
extends BaseRestHandler {
    public List<RestHandler.Route> routes() {
        return List.of(new RestHandler.Route(RestRequest.Method.PUT, "/_ilm/policy/{name}"));
    }

    public String getName() {
        return "ilm_put_action";
    }

    protected BaseRestHandler.RestChannelConsumer prepareRequest(final RestRequest restRequest, NodeClient client) throws IOException {
        PutLifecycleRequest putLifecycleRequest;
        try (XContentParser parser = restRequest.contentParser();){
            putLifecycleRequest = PutLifecycleRequest.parseRequest((PutLifecycleRequest.Factory)new PutLifecycleRequest.Factory(){

                public PutLifecycleRequest create(LifecyclePolicy lifecyclePolicy) {
                    return new PutLifecycleRequest(RestUtils.getMasterNodeTimeout((RestRequest)restRequest), RestUtils.getAckTimeout((RestRequest)restRequest), lifecyclePolicy);
                }

                public String getPolicyName() {
                    return restRequest.param("name");
                }
            }, (XContentParser)parser);
        }
        return channel -> client.execute(ILMActions.PUT, (ActionRequest)putLifecycleRequest, (ActionListener)new RestToXContentListener(channel));
    }

    public Set<String> supportedCapabilities() {
        return Set.of("searchable_snapshot_force_merge_on_clone");
    }
}

