/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.monitoring.exporter;

import java.io.IOException;
import java.io.OutputStream;
import java.util.Set;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.common.io.stream.BytesStreamOutput;
import org.elasticsearch.common.util.set.Sets;
import org.elasticsearch.common.xcontent.LoggingDeprecationHandler;
import org.elasticsearch.common.xcontent.XContentHelper;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.XContentBuilder;
import org.elasticsearch.xcontent.XContentParser;
import org.elasticsearch.xcontent.XContentParserConfiguration;
import org.elasticsearch.xcontent.XContentType;
import org.elasticsearch.xpack.core.monitoring.MonitoredSystem;
import org.elasticsearch.xpack.core.monitoring.exporter.MonitoringDoc;

public abstract class FilteredMonitoringDoc
extends MonitoringDoc {
    static final Set<String> COMMON_XCONTENT_FILTERS = Set.of("cluster_uuid", "timestamp", "interval_ms", "type", "source_node");
    private final Set<String> filters;

    public FilteredMonitoringDoc(String cluster, long timestamp, long intervalMillis, @Nullable MonitoringDoc.Node node, MonitoredSystem system, String type, @Nullable String id, Set<String> xContentFilters) {
        super(cluster, timestamp, intervalMillis, node, system, type, id);
        if (xContentFilters.isEmpty()) {
            throw new IllegalArgumentException("xContentFilters must not be empty");
        }
        this.filters = Sets.union(COMMON_XCONTENT_FILTERS, xContentFilters);
    }

    Set<String> getFilters() {
        return this.filters;
    }

    public final XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        try (BytesStreamOutput out = new BytesStreamOutput();){
            XContentBuilder xContentBuilder;
            block17: {
                try (XContentBuilder filteredBuilder = new XContentBuilder(builder.contentType(), (OutputStream)out, this.filters);){
                    super.toXContent(filteredBuilder, params);
                }
                XContentParser parser = XContentHelper.createParserNotCompressed((XContentParserConfiguration)LoggingDeprecationHandler.XCONTENT_PARSER_CONFIG, (BytesReference)out.bytes(), (XContentType)builder.contentType());
                try {
                    xContentBuilder = builder.copyCurrentStructure(parser);
                    if (parser == null) break block17;
                }
                catch (Throwable throwable) {
                    if (parser != null) {
                        try {
                            parser.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                parser.close();
            }
            return xContentBuilder;
        }
    }
}

