/*
 * Decompiled with CFR 0.152.
 */
package com.nvidia.cuvs.internal.common;

import com.nvidia.cuvs.internal.common.CloseableHandle;
import com.nvidia.cuvs.internal.common.LinkerHelper;
import com.nvidia.cuvs.internal.common.Util;
import com.nvidia.cuvs.internal.panama.headers_h;
import java.lang.foreign.Arena;
import java.lang.foreign.MemorySegment;

public class CloseableRMMAllocation
implements CloseableHandle {
    private final long cuvsResourceHandle;
    private long numBytes;
    private MemorySegment pointer;
    public static CloseableRMMAllocation EMPTY = new CloseableRMMAllocation(0L, 0L, MemorySegment.NULL);

    private CloseableRMMAllocation(long cuvsResourceHandle, long numBytes, MemorySegment pointer) {
        this.cuvsResourceHandle = cuvsResourceHandle;
        this.numBytes = numBytes;
        this.pointer = pointer;
    }

    public CloseableRMMAllocation(CloseableRMMAllocation other) {
        this.cuvsResourceHandle = other.cuvsResourceHandle;
        this.numBytes = other.numBytes;
        this.pointer = other.release();
    }

    public static CloseableRMMAllocation allocateRMMSegment(long cuvsResourceHandle, long numBytes) {
        try (Arena localArena = Arena.ofConfined();){
            MemorySegment datasetMemorySegment = localArena.allocate(LinkerHelper.C_POINTER);
            Util.checkCuVSError(headers_h.cuvsRMMAlloc(cuvsResourceHandle, datasetMemorySegment, numBytes), "cuvsRMMAlloc");
            CloseableRMMAllocation closeableRMMAllocation = new CloseableRMMAllocation(cuvsResourceHandle, numBytes, datasetMemorySegment.get(LinkerHelper.C_POINTER, 0L));
            return closeableRMMAllocation;
        }
    }

    @Override
    public MemorySegment handle() {
        return this.pointer;
    }

    private MemorySegment release() {
        MemorySegment oldPointer = this.pointer;
        this.pointer = MemorySegment.NULL;
        this.numBytes = 0L;
        return oldPointer;
    }

    private boolean mustClose() {
        return this.pointer != MemorySegment.NULL;
    }

    @Override
    public void close() {
        if (this.mustClose()) {
            Util.checkCuVSError(headers_h.cuvsRMMFree(this.cuvsResourceHandle, this.pointer, this.numBytes), "cuvsRMMFree");
            this.pointer = MemorySegment.NULL;
        }
    }
}

