/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.ml.inference.pytorch;

import java.util.Objects;
import java.util.concurrent.PriorityBlockingQueue;
import org.elasticsearch.common.util.concurrent.AbstractRunnable;
import org.elasticsearch.common.util.concurrent.EsRejectedExecutionException;
import org.elasticsearch.common.util.concurrent.ThreadContext;
import org.elasticsearch.common.util.concurrent.WrappedRunnable;
import org.elasticsearch.core.SuppressForbidden;
import org.elasticsearch.xpack.ml.job.process.AbstractInitializableRunnable;
import org.elasticsearch.xpack.ml.job.process.AbstractProcessWorkerExecutorService;

public class PriorityProcessWorkerExecutorService
extends AbstractProcessWorkerExecutorService<OrderedRunnable> {
    private final int queueCapacity;

    @SuppressForbidden(reason="properly rethrowing errors, see EsExecutors.rethrowErrors")
    public PriorityProcessWorkerExecutorService(ThreadContext contextHolder, String processName, int queueCapacity) {
        super(contextHolder, processName, queueCapacity, PriorityBlockingQueue::new);
        this.queueCapacity = queueCapacity;
    }

    public synchronized void executeWithPriority(AbstractInitializableRunnable command, RequestPriority priority, long tieBreaker) {
        command.init();
        if (this.isShutdown()) {
            EsRejectedExecutionException rejected = new EsRejectedExecutionException(this.processName + " worker service has shutdown", true);
            command.onRejection((Exception)((Object)rejected));
            this.notifyQueueRunnables();
            return;
        }
        if (this.queue.size() >= this.queueCapacity && priority != RequestPriority.HIGHEST) {
            command.onRejection((Exception)((Object)new EsRejectedExecutionException(this.processName + " queue is full. Unable to execute command", false)));
            return;
        }
        this.queue.offer(new OrderedRunnable(priority, tieBreaker, (AbstractRunnable)this.contextHolder.preserveContext((Runnable)((Object)command))));
        if (this.isShutdown()) {
            this.notifyQueueRunnables();
        }
    }

    @Override
    public synchronized void execute(Runnable command) {
        throw new UnsupportedOperationException("use executeWithPriority");
    }

    public static enum RequestPriority {
        HIGHEST,
        HIGH,
        NORMAL;

    }

    protected static final class OrderedRunnable
    extends AbstractRunnable
    implements Comparable<OrderedRunnable>,
    WrappedRunnable {
        private final RequestPriority priority;
        private final long tieBreaker;
        private final AbstractRunnable runnable;

        protected OrderedRunnable(RequestPriority priority, long tieBreaker, AbstractRunnable runnable) {
            this.priority = priority;
            this.tieBreaker = tieBreaker;
            this.runnable = runnable;
        }

        @Override
        public int compareTo(OrderedRunnable o) {
            int p = this.priority.compareTo(o.priority);
            if (p == 0) {
                return (int)(this.tieBreaker - o.tieBreaker);
            }
            return p;
        }

        public void onFailure(Exception e) {
            this.runnable.onFailure(e);
        }

        public void onRejection(Exception e) {
            this.runnable.onRejection(e);
        }

        protected void doRun() throws Exception {
            this.runnable.run();
        }

        public boolean isForceExecution() {
            return this.runnable.isForceExecution();
        }

        public void onAfter() {
            this.runnable.onAfter();
        }

        public Runnable unwrap() {
            return this.runnable;
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (obj == null || obj.getClass() != this.getClass()) {
                return false;
            }
            OrderedRunnable that = (OrderedRunnable)obj;
            return Objects.equals((Object)this.priority, (Object)that.priority) && this.tieBreaker == that.tieBreaker && Objects.equals(this.runnable, that.runnable);
        }

        public int hashCode() {
            return Objects.hash(new Object[]{this.priority, this.tieBreaker, this.runnable});
        }

        public String toString() {
            return "OrderedRunnable[priority=" + String.valueOf((Object)this.priority) + ", tieBreaker=" + this.tieBreaker + ", runnable=" + String.valueOf(this.runnable) + "]";
        }
    }
}

