/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.ml.extractor;

import java.util.List;
import java.util.Map;
import java.util.Set;
import org.elasticsearch.search.SearchHit;
import org.elasticsearch.xpack.ml.extractor.AbstractField;
import org.elasticsearch.xpack.ml.extractor.ExtractedField;
import org.elasticsearch.xpack.ml.extractor.SourceSupplier;

public class SourceField
extends AbstractField {
    private final String[] path;

    public SourceField(String name, Set<String> types) {
        super(name, types);
        this.path = name.split("\\.");
    }

    @Override
    public ExtractedField.Method getMethod() {
        return ExtractedField.Method.SOURCE;
    }

    @Override
    public Object[] value(SearchHit hit, SourceSupplier source) {
        Object values;
        int level;
        Map<String, Object> sourceMap = source.get();
        for (level = 0; sourceMap != null && level < this.path.length - 1; ++level) {
            sourceMap = SourceField.getNextLevel(sourceMap, this.path[level]);
        }
        if (sourceMap != null && (values = sourceMap.get(this.path[level])) != null) {
            if (values instanceof List) {
                List asList = (List)values;
                return asList.toArray(new Object[0]);
            }
            return new Object[]{values};
        }
        return new Object[0];
    }

    private static Map<String, Object> getNextLevel(Map<String, Object> source, String key) {
        Object firstElement;
        List asList;
        Object nextLevel = source.get(key);
        if (nextLevel instanceof Map) {
            return (Map)source.get(key);
        }
        if (nextLevel instanceof List && !(asList = (List)nextLevel).isEmpty() && (firstElement = asList.get(0)) instanceof Map) {
            return (Map)firstElement;
        }
        return null;
    }

    @Override
    public boolean supportsFromSource() {
        return true;
    }

    @Override
    public ExtractedField newFromSource() {
        return this;
    }

    @Override
    public boolean isMultiField() {
        return false;
    }
}

