/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.ml.autoscaling;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.cluster.node.DiscoveryNode;
import org.elasticsearch.cluster.node.DiscoveryNodeRole;
import org.elasticsearch.cluster.node.DiscoveryNodes;
import org.elasticsearch.cluster.routing.allocation.decider.AwarenessAllocationDecider;
import org.elasticsearch.common.settings.ClusterSettings;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.xpack.ml.autoscaling.AbstractNodeAvailabilityZoneMapper;
import org.elasticsearch.xpack.ml.autoscaling.NodeAvailabilityZoneMapper;

public class NodeRealAvailabilityZoneMapper
extends AbstractNodeAvailabilityZoneMapper {
    private static final Logger logger = LogManager.getLogger(NodeRealAvailabilityZoneMapper.class);
    private volatile List<String> awarenessAttributes;

    public NodeRealAvailabilityZoneMapper(Settings settings, ClusterSettings clusterSettings) {
        this(settings, clusterSettings, null);
    }

    public NodeRealAvailabilityZoneMapper(Settings settings, ClusterSettings clusterSettings, DiscoveryNodes discoveryNodes) {
        super(discoveryNodes);
        this.awarenessAttributes = (List)AwarenessAllocationDecider.CLUSTER_ROUTING_ALLOCATION_AWARENESS_ATTRIBUTE_SETTING.get(settings);
        this.updateNodesByAvailabilityZone();
        clusterSettings.addSettingsUpdateConsumer(AwarenessAllocationDecider.CLUSTER_ROUTING_ALLOCATION_AWARENESS_ATTRIBUTE_SETTING, this::setAwarenessAttributes);
    }

    private synchronized void setAwarenessAttributes(List<String> awarenessAttributes) {
        this.awarenessAttributes = List.copyOf(awarenessAttributes);
        this.updateNodesByAvailabilityZone();
    }

    public List<String> getAwarenessAttributes() {
        return this.awarenessAttributes;
    }

    @Override
    protected NodeAvailabilityZoneMapper.NodesByAvailabilityZone buildNodesByAvailabilityZone(Collection<DiscoveryNode> discoveryNodes) {
        return NodeRealAvailabilityZoneMapper.buildNodesByAvailabilityZone(discoveryNodes, this.awarenessAttributes);
    }

    private static NodeAvailabilityZoneMapper.NodesByAvailabilityZone buildNodesByAvailabilityZone(Collection<DiscoveryNode> nodes, List<String> awarenessAttributes) {
        if (awarenessAttributes.isEmpty()) {
            return new NodeAvailabilityZoneMapper.NodesByAvailabilityZone(Map.of(List.of(), nodes), Map.of(List.of(), nodes.stream().filter(n -> n.getRoles().contains(DiscoveryNodeRole.ML_ROLE)).toList()));
        }
        HashMap<List, Collection> allNodesByAvailabilityZone = new HashMap<List, Collection>();
        HashMap<List, Collection> mlNodesByAvailabilityZone = new HashMap<List, Collection>();
        for (DiscoveryNode node : nodes) {
            List<String> orderedNodeAttributeValues = awarenessAttributes.stream().map(a -> {
                String v = (String)node.getAttributes().get(a);
                if (v == null) {
                    logger.debug("Node [{}] does not have all configured awareness attributes {} - missing [{}]", (Object)node, (Object)awarenessAttributes, a);
                    return "";
                }
                return v;
            }).toList();
            allNodesByAvailabilityZone.computeIfAbsent(orderedNodeAttributeValues, k -> new ArrayList()).add(node);
            if (!node.getRoles().contains(DiscoveryNodeRole.ML_ROLE)) continue;
            mlNodesByAvailabilityZone.compute(orderedNodeAttributeValues, (k, v) -> {
                if (v == null) {
                    v = new ArrayList<DiscoveryNode>();
                }
                v.add(node);
                return v;
            });
        }
        return new NodeAvailabilityZoneMapper.NodesByAvailabilityZone(Map.copyOf(allNodesByAvailabilityZone), Map.copyOf(mlNodesByAvailabilityZone));
    }

    @Override
    public Map<List<String>, Collection<DiscoveryNode>> buildMlNodesByAvailabilityZone(List<DiscoveryNode> nodes) {
        return NodeRealAvailabilityZoneMapper.buildNodesByAvailabilityZone(nodes, this.awarenessAttributes).mlNodes();
    }
}

