/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.ml.aggs.kstest;

import java.io.IOException;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.elasticsearch.TransportVersion;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.search.aggregations.PipelineAggregationBuilder;
import org.elasticsearch.search.aggregations.pipeline.BucketHelpers;
import org.elasticsearch.search.aggregations.pipeline.BucketMetricsPipelineAggregationBuilder;
import org.elasticsearch.search.aggregations.pipeline.PipelineAggregator;
import org.elasticsearch.xcontent.ConstructingObjectParser;
import org.elasticsearch.xcontent.ObjectParser;
import org.elasticsearch.xcontent.ParseField;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.XContentBuilder;
import org.elasticsearch.xcontent.XContentLocation;
import org.elasticsearch.xcontent.XContentParser;
import org.elasticsearch.xpack.ml.aggs.kstest.Alternative;
import org.elasticsearch.xpack.ml.aggs.kstest.BucketCountKSTestAggregator;
import org.elasticsearch.xpack.ml.aggs.kstest.SamplingMethod;

public class BucketCountKSTestAggregationBuilder
extends BucketMetricsPipelineAggregationBuilder<BucketCountKSTestAggregationBuilder> {
    public static final ParseField NAME = new ParseField("bucket_count_ks_test", new String[0]);
    public static final ConstructingObjectParser<BucketCountKSTestAggregationBuilder, String> PARSER = new ConstructingObjectParser(NAME.getPreferredName(), false, (args, context) -> new BucketCountKSTestAggregationBuilder((String)context, (String)args[0], (List)args[1], (List)args[2], (BucketHelpers.GapPolicy)args[3], (SamplingMethod)args[4]));
    private static final ParseField ALTERNATIVE = new ParseField("alternative", new String[0]);
    private static final ParseField SAMPLING_METHOD = new ParseField("sampling_method", new String[0]);
    private static final ParseField FRACTIONS = new ParseField("fractions", new String[0]);
    private final double[] fractions;
    private final EnumSet<Alternative> alternative;
    private final SamplingMethod samplingMethod;

    private BucketCountKSTestAggregationBuilder(String name, String bucketsPath, @Nullable List<Double> fractions, @Nullable List<String> alternative, @Nullable BucketHelpers.GapPolicy gapPolicy, @Nullable SamplingMethod samplingMethod) {
        super(name, NAME.getPreferredName(), new String[]{bucketsPath}, null, gapPolicy == null ? BucketHelpers.GapPolicy.INSERT_ZEROS : gapPolicy);
        double[] dArray = this.fractions = fractions == null ? null : fractions.stream().mapToDouble(Double::doubleValue).toArray();
        if (alternative == null) {
            this.alternative = EnumSet.allOf(Alternative.class);
        } else {
            if (alternative.isEmpty()) {
                throw new IllegalArgumentException("[alternative] must not be empty for aggregation [" + name + "]");
            }
            List alternativeEnums = alternative.stream().map(Alternative::fromString).collect(Collectors.toList());
            this.alternative = EnumSet.copyOf(alternativeEnums);
        }
        SamplingMethod samplingMethod2 = this.samplingMethod = samplingMethod == null ? new SamplingMethod.UpperTail() : samplingMethod;
        if (gapPolicy != null && !gapPolicy.equals((Object)BucketHelpers.GapPolicy.INSERT_ZEROS)) {
            throw new IllegalArgumentException("only [" + PipelineAggregator.Parser.GAP_POLICY.getPreferredName() + "] of [" + BucketHelpers.GapPolicy.INSERT_ZEROS.getName() + "] is supported");
        }
    }

    public BucketCountKSTestAggregationBuilder(String name, String bucketsPath, List<Double> fractions, List<String> alternative, @Nullable SamplingMethod samplingMethod) {
        this(name, bucketsPath, fractions, alternative, BucketHelpers.GapPolicy.INSERT_ZEROS, samplingMethod);
    }

    public BucketCountKSTestAggregationBuilder(StreamInput in) throws IOException {
        super(in, NAME.getPreferredName());
        this.fractions = in.readBoolean() ? in.readDoubleArray() : null;
        this.alternative = in.readEnumSet(Alternative.class);
        this.samplingMethod = SamplingMethod.fromStream(in);
    }

    public String getWriteableName() {
        return NAME.getPreferredName();
    }

    protected void innerWriteTo(StreamOutput out) throws IOException {
        out.writeBoolean(this.fractions != null);
        if (this.fractions != null) {
            out.writeDoubleArray(this.fractions);
        }
        out.writeEnumSet(this.alternative);
        out.writeString(this.samplingMethod.getName());
    }

    protected PipelineAggregator createInternal(Map<String, Object> metadata) {
        return new BucketCountKSTestAggregator(this.name, this.fractions, this.alternative, this.bucketsPaths[0], this.samplingMethod, metadata);
    }

    protected boolean overrideBucketsPath() {
        return true;
    }

    protected XContentBuilder doXContentBody(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.field(BUCKETS_PATH_FIELD.getPreferredName(), this.bucketsPaths[0]);
        if (this.fractions != null) {
            builder.field(FRACTIONS.getPreferredName(), (Object)this.fractions);
        }
        builder.field(ALTERNATIVE.getPreferredName(), this.alternative);
        builder.field(SAMPLING_METHOD.getPreferredName(), this.samplingMethod.getName());
        return builder;
    }

    protected void validate(PipelineAggregationBuilder.ValidationContext context) {
        super.validate(context);
        if (!this.bucketsPaths[0].endsWith("_count")) {
            context.addBucketPathValidationError("[bucket_count_ks_test] requires that buckets_path points to bucket [_count]");
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        BucketCountKSTestAggregationBuilder that = (BucketCountKSTestAggregationBuilder)((Object)o);
        return Arrays.equals(this.fractions, that.fractions) && Objects.equals(this.alternative, that.alternative) && Objects.equals(this.samplingMethod, that.samplingMethod);
    }

    public int hashCode() {
        return Objects.hash(super.hashCode(), Arrays.hashCode(this.fractions), this.alternative, this.samplingMethod);
    }

    public TransportVersion getMinimalSupportedVersion() {
        return TransportVersion.zero();
    }

    static {
        PARSER.declareString(ConstructingObjectParser.constructorArg(), BUCKETS_PATH_FIELD);
        PARSER.declareDoubleArray(ConstructingObjectParser.optionalConstructorArg(), FRACTIONS);
        PARSER.declareStringArray(ConstructingObjectParser.optionalConstructorArg(), ALTERNATIVE);
        PARSER.declareField(ConstructingObjectParser.optionalConstructorArg(), p -> {
            if (p.currentToken() == XContentParser.Token.VALUE_STRING) {
                return BucketHelpers.GapPolicy.parse((String)p.text().toLowerCase(Locale.ROOT), (XContentLocation)p.getTokenLocation());
            }
            throw new IllegalArgumentException("Unsupported token [" + String.valueOf(p.currentToken()) + "]");
        }, PipelineAggregator.Parser.GAP_POLICY, ObjectParser.ValueType.STRING);
        PARSER.declareField(ConstructingObjectParser.optionalConstructorArg(), p -> {
            if (p.currentToken() == XContentParser.Token.VALUE_STRING) {
                return SamplingMethod.fromString(p.text().toLowerCase(Locale.ROOT));
            }
            throw new IllegalArgumentException("Unsupported token [" + String.valueOf(p.currentToken()) + "]");
        }, SAMPLING_METHOD, ObjectParser.ValueType.STRING);
    }
}

