/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.ml.action;

import java.io.IOException;
import java.time.Instant;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.atomic.AtomicReference;
import org.elasticsearch.ElasticsearchException;
import org.elasticsearch.ElasticsearchSecurityException;
import org.elasticsearch.ElasticsearchStatusException;
import org.elasticsearch.ResourceNotFoundException;
import org.elasticsearch.TransportVersion;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.ActionRequest;
import org.elasticsearch.action.ActionType;
import org.elasticsearch.action.admin.indices.stats.IndexStats;
import org.elasticsearch.action.search.SearchRequest;
import org.elasticsearch.action.support.ActionFilters;
import org.elasticsearch.action.support.master.MasterNodeRequest;
import org.elasticsearch.action.support.master.TransportMasterNodeAction;
import org.elasticsearch.client.internal.Client;
import org.elasticsearch.client.internal.OriginSettingClient;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.block.ClusterBlockException;
import org.elasticsearch.cluster.block.ClusterBlockLevel;
import org.elasticsearch.cluster.project.ProjectResolver;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.ValidationException;
import org.elasticsearch.common.VersionId;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.common.logging.HeaderWarning;
import org.elasticsearch.common.unit.ByteSizeValue;
import org.elasticsearch.common.util.concurrent.EsExecutors;
import org.elasticsearch.common.util.concurrent.ThreadContext;
import org.elasticsearch.common.xcontent.LoggingDeprecationHandler;
import org.elasticsearch.common.xcontent.XContentHelper;
import org.elasticsearch.core.TimeValue;
import org.elasticsearch.index.query.ConstantScoreQueryBuilder;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.QueryBuilders;
import org.elasticsearch.injection.guice.Inject;
import org.elasticsearch.license.License;
import org.elasticsearch.license.LicenseUtils;
import org.elasticsearch.license.XPackLicenseState;
import org.elasticsearch.rest.RestRequest;
import org.elasticsearch.rest.RestStatus;
import org.elasticsearch.search.builder.SearchSourceBuilder;
import org.elasticsearch.tasks.Task;
import org.elasticsearch.tasks.TaskInfo;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.TransportService;
import org.elasticsearch.xcontent.NamedXContentRegistry;
import org.elasticsearch.xcontent.XContentBuilder;
import org.elasticsearch.xcontent.XContentFactory;
import org.elasticsearch.xcontent.XContentParser;
import org.elasticsearch.xcontent.XContentParserConfiguration;
import org.elasticsearch.xcontent.XContentType;
import org.elasticsearch.xpack.core.ClientHelper;
import org.elasticsearch.xpack.core.ml.MachineLearningField;
import org.elasticsearch.xpack.core.ml.MlConfigVersion;
import org.elasticsearch.xpack.core.ml.action.GetTrainedModelsAction;
import org.elasticsearch.xpack.core.ml.action.PutTrainedModelAction;
import org.elasticsearch.xpack.core.ml.inference.ModelAliasMetadata;
import org.elasticsearch.xpack.core.ml.inference.TrainedModelConfig;
import org.elasticsearch.xpack.core.ml.inference.TrainedModelType;
import org.elasticsearch.xpack.core.ml.inference.assignment.TrainedModelAssignmentMetadata;
import org.elasticsearch.xpack.core.ml.inference.persistence.InferenceIndexConstants;
import org.elasticsearch.xpack.core.ml.inference.trainedmodel.InferenceConfig;
import org.elasticsearch.xpack.core.ml.inference.trainedmodel.LenientlyParsedInferenceConfig;
import org.elasticsearch.xpack.core.ml.inference.trainedmodel.ModelPackageConfig;
import org.elasticsearch.xpack.core.ml.inference.trainedmodel.TrainedModel;
import org.elasticsearch.xpack.core.ml.job.messages.Messages;
import org.elasticsearch.xpack.core.ml.packageloader.action.GetTrainedModelPackageConfigAction;
import org.elasticsearch.xpack.core.ml.packageloader.action.LoadTrainedModelPackageAction;
import org.elasticsearch.xpack.core.ml.utils.ExceptionsHelper;
import org.elasticsearch.xpack.core.ml.utils.MlPlatformArchitecturesUtil;
import org.elasticsearch.xpack.ml.action.TrainedModelValidator;
import org.elasticsearch.xpack.ml.inference.persistence.TrainedModelProvider;
import org.elasticsearch.xpack.ml.utils.TaskRetriever;

public class TransportPutTrainedModelAction
extends TransportMasterNodeAction<PutTrainedModelAction.Request, PutTrainedModelAction.Response> {
    private static final ByteSizeValue MAX_NATIVE_DEFINITION_INDEX_SIZE = ByteSizeValue.ofGb((long)50L);
    private final TrainedModelProvider trainedModelProvider;
    private final XPackLicenseState licenseState;
    private final NamedXContentRegistry xContentRegistry;
    private final OriginSettingClient client;
    private final ProjectResolver projectResolver;

    @Inject
    public TransportPutTrainedModelAction(TransportService transportService, ClusterService clusterService, ThreadPool threadPool, XPackLicenseState licenseState, ActionFilters actionFilters, Client client, TrainedModelProvider trainedModelProvider, NamedXContentRegistry xContentRegistry, ProjectResolver projectResolver) {
        super("cluster:admin/xpack/ml/inference/put", transportService, clusterService, threadPool, actionFilters, PutTrainedModelAction.Request::new, PutTrainedModelAction.Response::new, (Executor)EsExecutors.DIRECT_EXECUTOR_SERVICE);
        this.licenseState = licenseState;
        this.trainedModelProvider = trainedModelProvider;
        this.xContentRegistry = xContentRegistry;
        this.client = new OriginSettingClient(client, "ml");
        this.projectResolver = projectResolver;
    }

    protected void masterOperation(Task task, PutTrainedModelAction.Request request, ClusterState state, ActionListener<PutTrainedModelAction.Response> finalResponseListener) {
        boolean hasModelDefinition;
        TrainedModelConfig config = request.getTrainedModelConfig();
        try {
            if (!request.isDeferDefinitionDecompression()) {
                config.ensureParsedDefinition(this.xContentRegistry);
            }
        }
        catch (IOException ex) {
            finalResponseListener.onFailure((Exception)ExceptionsHelper.badRequestException((String)"Failed to parse definition for [{}]", (Throwable)ex, (Object[])new Object[]{config.getModelId()}));
            return;
        }
        boolean bl = hasModelDefinition = config.getModelDefinition() != null;
        if (hasModelDefinition && !TransportPutTrainedModelAction.validateModelDefinition(config, state, this.licenseState, finalResponseListener)) {
            return;
        }
        TrainedModelConfig.Builder trainedModelConfig = new TrainedModelConfig.Builder(config).setVersion(MlConfigVersion.CURRENT).setCreateTime(Instant.now()).setCreatedBy("api_user").setLicenseLevel(License.OperationMode.PLATINUM.description());
        AtomicReference modelPackageConfigHolder = new AtomicReference();
        if (hasModelDefinition) {
            trainedModelConfig.setModelSize(config.getModelDefinition().ramBytesUsed()).setEstimatedOperations(config.getModelDefinition().getTrainedModel().estimatedNumOperations());
        } else {
            trainedModelConfig.setLocation(Optional.ofNullable(config.getModelType()).orElse(TrainedModelType.TREE_ENSEMBLE).getDefaultLocation(config.getModelId()));
        }
        if (ModelAliasMetadata.fromState((ClusterState)state).getModelId(trainedModelConfig.getModelId()) != null) {
            finalResponseListener.onFailure((Exception)ExceptionsHelper.badRequestException((String)"requested model_id [{}] is the same as an existing model_alias. Model model_aliases and ids must be unique", (Object[])new Object[]{config.getModelId()}));
            return;
        }
        if (TrainedModelAssignmentMetadata.fromState((ClusterState)state).hasDeployment(trainedModelConfig.getModelId())) {
            finalResponseListener.onFailure((Exception)ExceptionsHelper.badRequestException((String)"Cannot create model [{}] the model id is the same as the deployment id of a current model deployment", (Object[])new Object[]{config.getModelId()}));
            return;
        }
        boolean isPackageModel = config.isPackagedModel();
        ActionListener checkStorageIndexSizeListener = finalResponseListener.delegateFailureAndWrap((delegate, bool) -> {
            TrainedModelConfig configToReturn = trainedModelConfig.clearDefinition().build();
            if (modelPackageConfigHolder.get() != null) {
                this.triggerModelFetchIfNecessary(configToReturn.getModelId(), (ModelPackageConfig)modelPackageConfigHolder.get(), request.isWaitForCompletion(), (ActionListener<Void>)delegate.delegateFailureAndWrap((l, cfg) -> l.onResponse((Object)new PutTrainedModelAction.Response(cfg))).delegateFailureAndWrap((l, cfg) -> this.verifyMlNodesAndModelArchitectures((TrainedModelConfig)cfg, (Client)this.client, this.threadPool, (ActionListener<TrainedModelConfig>)l)).delegateFailureAndWrap((l, downloadTriggered) -> l.onResponse((Object)configToReturn)));
            } else {
                delegate.onResponse((Object)new PutTrainedModelAction.Response(configToReturn));
            }
        }).delegateFailureAndWrap((l, r) -> this.trainedModelProvider.storeTrainedModel(trainedModelConfig.build(), (ActionListener<Boolean>)l, isPackageModel));
        ActionListener tagsModelIdCheckListener = ActionListener.wrap(r -> {
            if (TrainedModelType.PYTORCH.equals((Object)trainedModelConfig.getModelType())) {
                this.client.admin().indices().prepareStats(new String[]{InferenceIndexConstants.nativeDefinitionStore()}).clear().setStore(true).execute(ActionListener.wrap(stats -> {
                    IndexStats indexStats = (IndexStats)stats.getIndices().get(InferenceIndexConstants.nativeDefinitionStore());
                    if (indexStats != null && indexStats.getTotal().getStore().sizeInBytes() > MAX_NATIVE_DEFINITION_INDEX_SIZE.getBytes()) {
                        finalResponseListener.onFailure((Exception)new ElasticsearchStatusException("Native model store has exceeded the maximum acceptable size of {}, please delete older unused pytorch models", RestStatus.CONFLICT, new Object[]{MAX_NATIVE_DEFINITION_INDEX_SIZE.toString()}));
                        return;
                    }
                    checkStorageIndexSizeListener.onResponse(null);
                }, e -> {
                    if (ExceptionsHelper.unwrapCause((Throwable)e) instanceof ResourceNotFoundException) {
                        checkStorageIndexSizeListener.onResponse(null);
                        return;
                    }
                    finalResponseListener.onFailure((Exception)new ElasticsearchStatusException("Unable to calculate stats for definition storage index [{}], please try again later", RestStatus.SERVICE_UNAVAILABLE, (Throwable)e, new Object[]{InferenceIndexConstants.nativeDefinitionStore()}));
                }));
                return;
            }
            checkStorageIndexSizeListener.onResponse(null);
        }, arg_0 -> finalResponseListener.onFailure(arg_0));
        ActionListener modelIdTagCheckListener = ActionListener.wrap(r -> this.checkTagsAgainstModelIds(request.getTrainedModelConfig().getTags(), (ActionListener<Void>)tagsModelIdCheckListener), arg_0 -> finalResponseListener.onFailure(arg_0));
        ActionListener handlePackageAndTagsListener = ActionListener.wrap(r -> {
            if (isPackageModel) {
                this.resolvePackageConfig(trainedModelConfig.getModelId(), (ActionListener<ModelPackageConfig>)ActionListener.wrap(resolvedModelPackageConfig -> {
                    try {
                        TrainedModelValidator.validatePackage(trainedModelConfig, resolvedModelPackageConfig, state);
                    }
                    catch (ValidationException e) {
                        finalResponseListener.onFailure((Exception)((Object)e));
                        return;
                    }
                    modelPackageConfigHolder.set(resolvedModelPackageConfig);
                    TransportPutTrainedModelAction.setTrainedModelConfigFieldsFromPackagedModel(trainedModelConfig, resolvedModelPackageConfig, this.xContentRegistry);
                    this.checkModelIdAgainstTags(trainedModelConfig.getModelId(), (ActionListener<Void>)modelIdTagCheckListener);
                }, arg_0 -> ((ActionListener)finalResponseListener).onFailure(arg_0)));
            } else {
                this.checkModelIdAgainstTags(trainedModelConfig.getModelId(), (ActionListener<Void>)modelIdTagCheckListener);
            }
        }, arg_0 -> finalResponseListener.onFailure(arg_0));
        TransportPutTrainedModelAction.checkForExistingModelDownloadTask((Client)this.client, trainedModelConfig.getModelId(), request.isWaitForCompletion(), finalResponseListener, () -> handlePackageAndTagsListener.onResponse(null), request.ackTimeout());
    }

    void verifyMlNodesAndModelArchitectures(final TrainedModelConfig configToReturn, Client client, ThreadPool threadPool, final ActionListener<TrainedModelConfig> configToReturnListener) {
        ActionListener<TrainedModelConfig> addWarningHeaderOnFailureListener = new ActionListener<TrainedModelConfig>(this){

            public void onResponse(TrainedModelConfig config) {
                assert (Objects.equals(config, configToReturn));
                configToReturnListener.onResponse((Object)configToReturn);
            }

            public void onFailure(Exception e) {
                HeaderWarning.addWarning((String)e.getMessage(), (Object[])new Object[0]);
                configToReturnListener.onResponse((Object)configToReturn);
            }
        };
        this.callVerifyMlNodesAndModelArchitectures(configToReturn, addWarningHeaderOnFailureListener, client, threadPool);
    }

    void callVerifyMlNodesAndModelArchitectures(TrainedModelConfig configToReturn, ActionListener<TrainedModelConfig> failureListener, Client client, ThreadPool threadPool) {
        MlPlatformArchitecturesUtil.verifyMlNodesAndModelArchitectures(failureListener, (Client)client, (ExecutorService)threadPool.executor("ml_utility"), (TrainedModelConfig)configToReturn);
    }

    static void checkForExistingModelDownloadTask(Client client, String modelId, boolean isWaitForCompletion, ActionListener<PutTrainedModelAction.Response> isBeingDownloadedListener, Runnable createModelAction, TimeValue timeout) {
        TaskRetriever.getDownloadTaskInfo(client, modelId, isWaitForCompletion, timeout, () -> "Timed out waiting for model download to complete", (ActionListener<TaskInfo>)ActionListener.wrap(taskInfo -> {
            if (taskInfo != null) {
                TransportPutTrainedModelAction.getModelInformation(client, modelId, isBeingDownloadedListener);
            } else {
                createModelAction.run();
            }
        }, arg_0 -> isBeingDownloadedListener.onFailure(arg_0)));
    }

    private static void getModelInformation(Client client, String modelId, ActionListener<PutTrainedModelAction.Response> listener) {
        client.execute((ActionType)GetTrainedModelsAction.INSTANCE, (ActionRequest)new GetTrainedModelsAction.Request(modelId), ActionListener.wrap(models -> {
            if (models.getResources().results().isEmpty()) {
                listener.onFailure((Exception)new ElasticsearchStatusException("No model information found for a concurrent create model execution for model id [{}]", RestStatus.INTERNAL_SERVER_ERROR, new Object[]{modelId}));
            } else {
                listener.onResponse((Object)new PutTrainedModelAction.Response((TrainedModelConfig)models.getResources().results().get(0)));
            }
        }, e -> listener.onFailure((Exception)new ElasticsearchStatusException("Unable to retrieve model information for a concurrent create model execution for model id [{}]", RestStatus.INTERNAL_SERVER_ERROR, (Throwable)e, new Object[]{modelId}))));
    }

    private void triggerModelFetchIfNecessary(String modelId, ModelPackageConfig modelPackageConfig, boolean waitForCompletion, ActionListener<Void> listener) {
        this.client.execute((ActionType)LoadTrainedModelPackageAction.INSTANCE, (ActionRequest)new LoadTrainedModelPackageAction.Request(modelId, modelPackageConfig, waitForCompletion), ActionListener.wrap(ack -> listener.onResponse(null), arg_0 -> listener.onFailure(arg_0)));
    }

    private void resolvePackageConfig(String modelId, ActionListener<ModelPackageConfig> listener) {
        this.client.execute((ActionType)GetTrainedModelPackageConfigAction.INSTANCE, (ActionRequest)new GetTrainedModelPackageConfigAction.Request(modelId.substring(1)), ActionListener.wrap(packageConfig -> listener.onResponse((Object)packageConfig.getModelPackageConfig()), arg_0 -> listener.onFailure(arg_0)));
    }

    private void checkModelIdAgainstTags(String modelId, ActionListener<Void> listener) {
        ConstantScoreQueryBuilder builder = QueryBuilders.constantScoreQuery((QueryBuilder)QueryBuilders.boolQuery().filter((QueryBuilder)QueryBuilders.termQuery((String)TrainedModelConfig.TAGS.getPreferredName(), (String)modelId)));
        SearchSourceBuilder sourceBuilder = new SearchSourceBuilder().query((QueryBuilder)builder).size(0).trackTotalHitsUpTo(1);
        SearchRequest searchRequest = new SearchRequest(new String[]{".ml-inference-*"}).source(sourceBuilder);
        ClientHelper.executeAsyncWithOrigin((ThreadContext)this.client.threadPool().getThreadContext(), (String)"ml", (Object)searchRequest, (ActionListener)ActionListener.wrap(response -> {
            if (response.getHits().getTotalHits().value() > 0L) {
                listener.onFailure((Exception)ExceptionsHelper.badRequestException((String)Messages.getMessage((String)"The provided model_id {0} must not match existing tags.", (Object[])new Object[]{modelId}), (Object[])new Object[0]));
                return;
            }
            listener.onResponse(null);
        }, arg_0 -> listener.onFailure(arg_0)), (arg_0, arg_1) -> ((OriginSettingClient)this.client).search(arg_0, arg_1));
    }

    private void checkTagsAgainstModelIds(List<String> tags, ActionListener<Void> listener) {
        if (tags.isEmpty()) {
            listener.onResponse(null);
            return;
        }
        ConstantScoreQueryBuilder builder = QueryBuilders.constantScoreQuery((QueryBuilder)QueryBuilders.boolQuery().filter((QueryBuilder)QueryBuilders.termsQuery((String)TrainedModelConfig.MODEL_ID.getPreferredName(), tags)));
        SearchSourceBuilder sourceBuilder = new SearchSourceBuilder().query((QueryBuilder)builder).size(0).trackTotalHitsUpTo(1);
        SearchRequest searchRequest = new SearchRequest(new String[]{".ml-inference-*"}).source(sourceBuilder);
        ClientHelper.executeAsyncWithOrigin((ThreadContext)this.client.threadPool().getThreadContext(), (String)"ml", (Object)searchRequest, (ActionListener)ActionListener.wrap(response -> {
            if (response.getHits().getTotalHits().value() > 0L) {
                listener.onFailure((Exception)ExceptionsHelper.badRequestException((String)Messages.getMessage((String)"The provided tags {0} must not match existing model_ids.", (Object[])new Object[]{tags}), (Object[])new Object[0]));
                return;
            }
            listener.onResponse(null);
        }, arg_0 -> listener.onFailure(arg_0)), (arg_0, arg_1) -> ((OriginSettingClient)this.client).search(arg_0, arg_1));
    }

    public static boolean validateModelDefinition(TrainedModelConfig config, ClusterState state, XPackLicenseState licenseState, ActionListener<PutTrainedModelAction.Response> finalResponseListener) {
        try {
            config.getModelDefinition().getTrainedModel().validate();
        }
        catch (ElasticsearchException ex) {
            finalResponseListener.onFailure((Exception)ExceptionsHelper.badRequestException((String)"Definition for [{}] has validation failures.", (Throwable)ex, (Object[])new Object[]{config.getModelId()}));
            return false;
        }
        TrainedModelType trainedModelType = TrainedModelType.typeFromTrainedModel((TrainedModel)config.getModelDefinition().getTrainedModel());
        if (trainedModelType == null) {
            finalResponseListener.onFailure((Exception)ExceptionsHelper.badRequestException((String)"Unknown trained model definition class [{}]", (Object[])new Object[]{config.getModelDefinition().getTrainedModel().getName()}));
            return false;
        }
        TrainedModelType configModelType = config.getModelType();
        if (configModelType == null) {
            config = new TrainedModelConfig.Builder(config).setModelType(trainedModelType).build();
        } else if (trainedModelType != configModelType) {
            finalResponseListener.onFailure((Exception)ExceptionsHelper.badRequestException((String)"{} [{}] does not match the model definition type [{}]", (Object[])new Object[]{TrainedModelConfig.MODEL_TYPE.getPreferredName(), configModelType, trainedModelType}));
            return false;
        }
        InferenceConfig inferenceConfig = config.getInferenceConfig();
        if (!inferenceConfig.isTargetTypeSupported(config.getModelDefinition().getTrainedModel().targetType())) {
            finalResponseListener.onFailure((Exception)ExceptionsHelper.badRequestException((String)"Model [{}] inference config type [{}] does not support definition target type [{}]", (Object[])new Object[]{config.getModelId(), config.getInferenceConfig().getName(), config.getModelDefinition().getTrainedModel().targetType()}));
            return false;
        }
        License.OperationMode minLicenseSupported = inferenceConfig.getMinLicenseSupportedForAction(RestRequest.Method.PUT);
        if (!licenseState.isAllowedByLicense(minLicenseSupported)) {
            finalResponseListener.onFailure((Exception)new ElasticsearchSecurityException("Model of type [{}] requires [{}] license level", RestStatus.FORBIDDEN, new Object[]{config.getInferenceConfig().getName(), minLicenseSupported}));
            return false;
        }
        TransportVersion minCompatibilityVersion = config.getModelDefinition().getTrainedModel().getMinimalCompatibilityVersion();
        if (state.getMinTransportVersion().before((VersionId)minCompatibilityVersion)) {
            finalResponseListener.onFailure((Exception)ExceptionsHelper.badRequestException((String)"Cannot create model [{}] while cluster upgrade is in progress.", (Object[])new Object[]{config.getModelId()}));
            return false;
        }
        return true;
    }

    protected ClusterBlockException checkBlock(PutTrainedModelAction.Request request, ClusterState state) {
        return state.blocks().globalBlockedException(this.projectResolver.getProjectId(), ClusterBlockLevel.METADATA_WRITE);
    }

    protected void doExecute(Task task, PutTrainedModelAction.Request request, ActionListener<PutTrainedModelAction.Response> listener) {
        if (MachineLearningField.ML_API_FEATURE.check(this.licenseState)) {
            super.doExecute(task, (MasterNodeRequest)request, listener);
        } else {
            listener.onFailure((Exception)LicenseUtils.newComplianceException((String)"ml"));
        }
    }

    static void setTrainedModelConfigFieldsFromPackagedModel(TrainedModelConfig.Builder trainedModelConfig, ModelPackageConfig resolvedModelPackageConfig, NamedXContentRegistry xContentRegistry) throws IOException {
        trainedModelConfig.setDescription(resolvedModelPackageConfig.getDescription());
        trainedModelConfig.setModelType(TrainedModelType.fromString((String)resolvedModelPackageConfig.getModelType()));
        trainedModelConfig.setPlatformArchitecture(resolvedModelPackageConfig.getPlatformArchitecture());
        trainedModelConfig.setMetadata(resolvedModelPackageConfig.getMetadata());
        trainedModelConfig.setInferenceConfig(TransportPutTrainedModelAction.parseInferenceConfigFromModelPackage(resolvedModelPackageConfig.getInferenceConfigSource(), xContentRegistry));
        trainedModelConfig.setTags(resolvedModelPackageConfig.getTags());
        trainedModelConfig.setPrefixStrings(resolvedModelPackageConfig.getPrefixStrings());
        trainedModelConfig.setModelPackageConfig(new ModelPackageConfig.Builder(resolvedModelPackageConfig).resetPackageOnlyFields().build());
        trainedModelConfig.setLocation(trainedModelConfig.getModelType().getDefaultLocation(trainedModelConfig.getModelId()));
    }

    static InferenceConfig parseInferenceConfigFromModelPackage(Map<String, Object> source, NamedXContentRegistry namedXContentRegistry) throws IOException {
        try (XContentBuilder xContentBuilder = XContentFactory.jsonBuilder().map(source);){
            InferenceConfig inferenceConfig;
            block15: {
                XContentParser sourceParser = XContentHelper.createParserNotCompressed((XContentParserConfiguration)LoggingDeprecationHandler.XCONTENT_PARSER_CONFIG.withRegistry(namedXContentRegistry), (BytesReference)BytesReference.bytes((XContentBuilder)xContentBuilder), (XContentType)XContentType.JSON);
                try {
                    XContentParser.Token token = sourceParser.nextToken();
                    assert (token == XContentParser.Token.START_OBJECT);
                    token = sourceParser.nextToken();
                    assert (token == XContentParser.Token.FIELD_NAME);
                    String currentName = sourceParser.currentName();
                    InferenceConfig inferenceConfig2 = (InferenceConfig)sourceParser.namedObject(LenientlyParsedInferenceConfig.class, currentName, null);
                    token = sourceParser.nextToken();
                    assert (token == XContentParser.Token.END_OBJECT);
                    inferenceConfig = inferenceConfig2;
                    if (sourceParser == null) break block15;
                }
                catch (Throwable throwable) {
                    if (sourceParser != null) {
                        try {
                            sourceParser.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                sourceParser.close();
            }
            return inferenceConfig;
        }
    }
}

