/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.ml.action;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Executor;
import org.elasticsearch.ResourceNotFoundException;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.ActionRequest;
import org.elasticsearch.action.ActionType;
import org.elasticsearch.action.bulk.BulkRequestBuilder;
import org.elasticsearch.action.bulk.BulkResponse;
import org.elasticsearch.action.bulk.TransportBulkAction;
import org.elasticsearch.action.delete.DeleteRequest;
import org.elasticsearch.action.support.ActionFilters;
import org.elasticsearch.action.support.HandledTransportAction;
import org.elasticsearch.action.support.WriteRequest;
import org.elasticsearch.action.support.master.AcknowledgedResponse;
import org.elasticsearch.client.internal.Client;
import org.elasticsearch.common.util.concurrent.EsExecutors;
import org.elasticsearch.injection.guice.Inject;
import org.elasticsearch.rest.RestStatus;
import org.elasticsearch.tasks.Task;
import org.elasticsearch.transport.TransportService;
import org.elasticsearch.xpack.core.ClientHelper;
import org.elasticsearch.xpack.core.ml.MlMetaIndex;
import org.elasticsearch.xpack.core.ml.action.DeleteFilterAction;
import org.elasticsearch.xpack.core.ml.job.config.Detector;
import org.elasticsearch.xpack.core.ml.job.config.Job;
import org.elasticsearch.xpack.core.ml.job.config.MlFilter;
import org.elasticsearch.xpack.core.ml.job.messages.Messages;
import org.elasticsearch.xpack.core.ml.utils.ExceptionsHelper;
import org.elasticsearch.xpack.ml.job.persistence.JobConfigProvider;

public class TransportDeleteFilterAction
extends HandledTransportAction<DeleteFilterAction.Request, AcknowledgedResponse> {
    private final Client client;
    private final JobConfigProvider jobConfigProvider;

    @Inject
    public TransportDeleteFilterAction(TransportService transportService, ActionFilters actionFilters, Client client, JobConfigProvider jobConfigProvider) {
        super("cluster:admin/xpack/ml/filters/delete", transportService, actionFilters, DeleteFilterAction.Request::new, (Executor)EsExecutors.DIRECT_EXECUTOR_SERVICE);
        this.client = client;
        this.jobConfigProvider = jobConfigProvider;
    }

    protected void doExecute(Task task, DeleteFilterAction.Request request, ActionListener<AcknowledgedResponse> listener) {
        String filterId = request.getFilterId();
        this.jobConfigProvider.findJobsWithCustomRules((ActionListener<List<Job>>)listener.delegateFailureAndWrap((delegate, jobs) -> {
            List<String> currentlyUsedBy = TransportDeleteFilterAction.findJobsUsingFilter(jobs, filterId);
            if (!currentlyUsedBy.isEmpty()) {
                delegate.onFailure((Exception)ExceptionsHelper.conflictStatusException((String)Messages.getMessage((String)"Cannot delete filter [{0}] currently used by jobs {1}", (Object[])new Object[]{filterId, currentlyUsedBy}), (Object[])new Object[0]));
            } else {
                this.deleteFilter(filterId, (ActionListener<AcknowledgedResponse>)delegate);
            }
        }));
    }

    private static List<String> findJobsUsingFilter(List<Job> jobs, String filterId) {
        ArrayList<String> currentlyUsedBy = new ArrayList<String>();
        block0: for (Job job : jobs) {
            List detectors = job.getAnalysisConfig().getDetectors();
            for (Detector detector : detectors) {
                if (!detector.extractReferencedFilters().contains(filterId)) continue;
                currentlyUsedBy.add(job.getId());
                continue block0;
            }
        }
        return currentlyUsedBy;
    }

    private void deleteFilter(final String filterId, final ActionListener<AcknowledgedResponse> listener) {
        DeleteRequest deleteRequest = new DeleteRequest(MlMetaIndex.indexName(), MlFilter.documentId((String)filterId));
        BulkRequestBuilder bulkRequestBuilder = this.client.prepareBulk();
        bulkRequestBuilder.add(deleteRequest);
        bulkRequestBuilder.setRefreshPolicy(WriteRequest.RefreshPolicy.IMMEDIATE);
        ClientHelper.executeAsyncWithOrigin((Client)this.client, (String)"ml", (ActionType)TransportBulkAction.TYPE, (ActionRequest)bulkRequestBuilder.request(), (ActionListener)new ActionListener<BulkResponse>(){

            public void onResponse(BulkResponse bulkResponse) {
                if (bulkResponse.getItems()[0].status() == RestStatus.NOT_FOUND) {
                    listener.onFailure((Exception)new ResourceNotFoundException("Could not delete filter with ID [" + filterId + "] because it does not exist", new Object[0]));
                } else {
                    listener.onResponse((Object)AcknowledgedResponse.TRUE);
                }
            }

            public void onFailure(Exception e) {
                listener.onFailure((Exception)ExceptionsHelper.serverError((String)("Could not delete filter with ID [" + filterId + "]"), (Throwable)e));
            }
        });
    }
}

