/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.spatial.common;

import java.util.ArrayList;
import java.util.function.BiPredicate;
import org.apache.lucene.geo.LatLonGeometry;
import org.apache.lucene.spatial3d.geom.GeoPoint;
import org.apache.lucene.spatial3d.geom.GeoPolygon;
import org.apache.lucene.spatial3d.geom.GeoPolygonFactory;
import org.apache.lucene.spatial3d.geom.PlanetModel;
import org.elasticsearch.common.geo.GeoBoundingBox;
import org.elasticsearch.h3.CellBoundary;
import org.elasticsearch.h3.H3;
import org.elasticsearch.h3.LatLng;
import org.elasticsearch.xpack.spatial.common.H3SphericalGeometry;

public final class H3SphericalUtil {
    private static final BiPredicate<LatLng, LatLng> MIN_COMPARATOR = (e1, e2) -> e1.getLatRad() < e2.getLatRad();
    private static final BiPredicate<LatLng, LatLng> MAX_COMPARATOR = (e1, e2) -> e1.getLatRad() > e2.getLatRad();

    public static void computeGeoBounds(long h3, GeoBoundingBox boundingBox) {
        CellBoundary boundary = H3.h3ToGeoBoundary((long)h3);
        int res = H3.getResolution((long)h3);
        if (h3 == H3.northPolarH3((int)res)) {
            H3SphericalUtil.computeNorthPoleBounds(boundary, boundingBox);
        } else if (h3 == H3.southPolarH3((int)res)) {
            H3SphericalUtil.computeSouthPoleBounds(boundary, boundingBox);
        } else {
            H3SphericalUtil.computeBounds(boundary, boundingBox);
        }
    }

    private static void computeNorthPoleBounds(CellBoundary boundary, GeoBoundingBox boundingBox) {
        double minLat = Double.POSITIVE_INFINITY;
        for (int i = 0; i < boundary.numPoints(); ++i) {
            minLat = Math.min(minLat, boundary.getLatLon(i).getLatRad());
        }
        boundingBox.topLeft().reset(90.0, -180.0);
        boundingBox.bottomRight().reset(Math.toDegrees(minLat), 180.0);
    }

    private static void computeSouthPoleBounds(CellBoundary boundary, GeoBoundingBox boundingBox) {
        double maxLat = Double.NEGATIVE_INFINITY;
        for (int i = 0; i < boundary.numPoints(); ++i) {
            maxLat = Math.max(maxLat, boundary.getLatLon(i).getLatRad());
        }
        boundingBox.topLeft().reset(Math.toDegrees(maxLat), -180.0);
        boundingBox.bottomRight().reset(-90.0, 180.0);
    }

    private static void computeBounds(CellBoundary boundary, GeoBoundingBox boundingBox) {
        double minLat = Double.POSITIVE_INFINITY;
        int minLatPos = -1;
        double minLon = Double.POSITIVE_INFINITY;
        double maxLat = Double.NEGATIVE_INFINITY;
        int maxLatPos = -1;
        double maxLon = Double.NEGATIVE_INFINITY;
        double maxNegLon = Double.NEGATIVE_INFINITY;
        double minPosLon = Double.POSITIVE_INFINITY;
        for (int i = 0; i < boundary.numPoints(); ++i) {
            double lon = boundary.getLatLon(i).getLonRad();
            double lat = boundary.getLatLon(i).getLatRad();
            if (lat < minLat) {
                minLat = lat;
                minLatPos = i;
            }
            if (lat > maxLat) {
                maxLat = lat;
                maxLatPos = i;
            }
            minLon = Math.min(minLon, lon);
            maxLon = Math.max(maxLon, lon);
            if (lon < 0.0) {
                maxNegLon = Math.max(maxNegLon, lon);
                continue;
            }
            minPosLon = Math.min(minPosLon, lon);
        }
        if (minLat < 0.0) {
            minLat = boundary.getLatLon(minLatPos).greatCircleMinLatitude(H3SphericalUtil.computeEdge(boundary, minLatPos, MIN_COMPARATOR));
        }
        if (maxLat > 0.0) {
            maxLat = boundary.getLatLon(maxLatPos).greatCircleMaxLatitude(H3SphericalUtil.computeEdge(boundary, maxLatPos, MAX_COMPARATOR));
        }
        boolean crossesDateline = maxLon - minLon > Math.PI;
        boundingBox.topLeft().reset(Math.toDegrees(maxLat), crossesDateline ? Math.toDegrees(minPosLon) : Math.toDegrees(minLon));
        boundingBox.bottomRight().reset(Math.toDegrees(minLat), crossesDateline ? Math.toDegrees(maxNegLon) : Math.toDegrees(maxLon));
    }

    private static LatLng computeEdge(CellBoundary boundary, int pos, BiPredicate<LatLng, LatLng> comparator) {
        LatLng end1 = boundary.getLatLon((pos + 1) % boundary.numPoints());
        LatLng end2 = boundary.getLatLon(pos == 0 ? boundary.numPoints() - 1 : pos - 1);
        return comparator.test(end1, end2) ? end1 : end2;
    }

    public static GeoPolygon toGeoPolygon(long h3) {
        CellBoundary boundary = H3.h3ToGeoBoundary((long)h3);
        ArrayList<GeoPoint> points = new ArrayList<GeoPoint>(boundary.numPoints());
        for (int i = 0; i < boundary.numPoints(); ++i) {
            LatLng latLng = boundary.getLatLon(i);
            points.add(new GeoPoint(PlanetModel.SPHERE, latLng.getLatRad(), latLng.getLonRad()));
        }
        return GeoPolygonFactory.makeGeoPolygon((PlanetModel)PlanetModel.SPHERE, points);
    }

    public static LatLonGeometry getLatLonGeometry(long h3) {
        return new H3SphericalGeometry(h3);
    }
}

