/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.security.transport;

import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.transport.RemoteClusterPortSettings;
import org.elasticsearch.xpack.core.XPackSettings;
import org.elasticsearch.xpack.core.security.SecurityField;
import org.elasticsearch.xpack.core.ssl.SSLService;
import org.elasticsearch.xpack.core.ssl.SslProfile;

public final class ProfileConfigurations {
    private ProfileConfigurations() {
    }

    public static Map<String, SslProfile> get(Settings settings, SSLService sslService, boolean sslEnabledOnly) {
        boolean transportSslEnabled = (Boolean)XPackSettings.TRANSPORT_SSL_ENABLED.get(settings);
        boolean remoteClusterPortEnabled = (Boolean)RemoteClusterPortSettings.REMOTE_CLUSTER_SERVER_ENABLED.get(settings);
        boolean remoteClusterServerSslEnabled = remoteClusterPortEnabled && (Boolean)XPackSettings.REMOTE_CLUSTER_SERVER_SSL_ENABLED.get(settings) != false;
        HashMap<String, SslProfile> profileConfigurations = new HashMap<String, SslProfile>();
        if (sslEnabledOnly) {
            if (!transportSslEnabled && !remoteClusterServerSslEnabled) {
                return profileConfigurations;
            }
            if (!transportSslEnabled) {
                SslProfile profile = ProfileConfigurations.getSslProfile(sslService, XPackSettings.REMOTE_CLUSTER_SERVER_SSL_PREFIX);
                profileConfigurations.put("_remote_cluster", profile);
                return profileConfigurations;
            }
            if (!remoteClusterServerSslEnabled) {
                ProfileConfigurations.populateFromTransportProfiles(settings, sslService, profileConfigurations);
                return profileConfigurations;
            }
        }
        ProfileConfigurations.populateFromTransportProfiles(settings, sslService, profileConfigurations);
        if (remoteClusterPortEnabled) {
            assert (!profileConfigurations.containsKey("_remote_cluster"));
            profileConfigurations.put("_remote_cluster", ProfileConfigurations.getSslProfile(sslService, XPackSettings.REMOTE_CLUSTER_SERVER_SSL_PREFIX));
        }
        return profileConfigurations;
    }

    private static void populateFromTransportProfiles(Settings settings, SSLService sslService, Map<String, SslProfile> profileConfigurations) {
        SslProfile defaultProfile = ProfileConfigurations.getSslProfile(sslService, SecurityField.setting((String)"transport.ssl."));
        Set profileNames = settings.getGroups("transport.profiles.", true).keySet();
        for (String profileName : profileNames) {
            if (profileName.equals("default")) {
                if (settings.getByPrefix("transport.profiles.default.xpack.security.ssl.").isEmpty()) continue;
                throw new IllegalArgumentException("SSL settings should not be configured for the default profile. Use the [xpack.security.transport.ssl] settings instead.");
            }
            SslProfile profile = ProfileConfigurations.getSslProfile(sslService, "transport.profiles." + profileName + "." + SecurityField.setting((String)"ssl"));
            profileConfigurations.put(profileName, profile);
        }
        assert (!profileConfigurations.containsKey("default"));
        profileConfigurations.put("default", defaultProfile);
    }

    private static SslProfile getSslProfile(SSLService sslService, String profileName) {
        SslProfile profile = sslService.profile(profileName);
        assert (profile != null) : "Null Ssl profile for [" + profileName + "] (is [" + String.valueOf(sslService) + "] a mock?)";
        return profile;
    }
}

