/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.datastreams.action;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Executor;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.datastreams.GetDataStreamMappingsAction;
import org.elasticsearch.action.support.ActionFilters;
import org.elasticsearch.action.support.IndicesOptions;
import org.elasticsearch.action.support.local.TransportLocalProjectMetadataAction;
import org.elasticsearch.cluster.ProjectState;
import org.elasticsearch.cluster.block.ClusterBlockException;
import org.elasticsearch.cluster.block.ClusterBlockLevel;
import org.elasticsearch.cluster.metadata.DataStream;
import org.elasticsearch.cluster.metadata.IndexNameExpressionResolver;
import org.elasticsearch.cluster.project.ProjectResolver;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.indices.IndicesService;
import org.elasticsearch.injection.guice.Inject;
import org.elasticsearch.tasks.Task;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.TransportService;

public class TransportGetDataStreamMappingsAction
extends TransportLocalProjectMetadataAction<GetDataStreamMappingsAction.Request, GetDataStreamMappingsAction.Response> {
    private final IndexNameExpressionResolver indexNameExpressionResolver;
    private final IndicesService indicesService;

    @Inject
    public TransportGetDataStreamMappingsAction(TransportService transportService, ClusterService clusterService, ThreadPool threadPool, ActionFilters actionFilters, ProjectResolver projectResolver, IndexNameExpressionResolver indexNameExpressionResolver, IndicesService indicesService) {
        super("indices:monitor/settings/get", actionFilters, transportService.getTaskManager(), clusterService, (Executor)threadPool.executor("management"), projectResolver);
        this.indexNameExpressionResolver = indexNameExpressionResolver;
        this.indicesService = indicesService;
    }

    protected ClusterBlockException checkBlock(GetDataStreamMappingsAction.Request request, ProjectState state) {
        return state.blocks().globalBlockedException(ClusterBlockLevel.METADATA_READ);
    }

    protected void localClusterStateOperation(Task task, GetDataStreamMappingsAction.Request request, ProjectState project, ActionListener<GetDataStreamMappingsAction.Response> listener) throws Exception {
        List dataStreamNames = this.indexNameExpressionResolver.dataStreamNames(project.metadata(), IndicesOptions.DEFAULT, request.indices());
        Map dataStreamMap = project.metadata().dataStreams();
        ArrayList<GetDataStreamMappingsAction.DataStreamMappingsResponse> responseList = new ArrayList<GetDataStreamMappingsAction.DataStreamMappingsResponse>(dataStreamNames.size());
        for (String dataStreamName : dataStreamNames) {
            DataStream dataStream = (DataStream)dataStreamMap.get(dataStreamName);
            responseList.add(new GetDataStreamMappingsAction.DataStreamMappingsResponse(dataStreamName, dataStream.getMappings(), dataStream.getEffectiveMappings(project.metadata(), this.indicesService)));
        }
        listener.onResponse((Object)new GetDataStreamMappingsAction.Response(responseList));
    }
}

