/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.logsdb.patterntext;

import java.io.IOException;
import java.io.UncheckedIOException;
import org.apache.lucene.index.LeafReader;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.search.SortField;
import org.apache.lucene.util.BytesRef;
import org.elasticsearch.common.util.BigArrays;
import org.elasticsearch.index.fielddata.IndexFieldData;
import org.elasticsearch.index.fielddata.IndexFieldDataCache;
import org.elasticsearch.index.fielddata.LeafFieldData;
import org.elasticsearch.index.fielddata.SortedBinaryDocValues;
import org.elasticsearch.indices.breaker.CircuitBreakerService;
import org.elasticsearch.script.field.DocValuesScriptFieldFactory;
import org.elasticsearch.script.field.KeywordDocValuesField;
import org.elasticsearch.script.field.ToScriptFieldFactory;
import org.elasticsearch.search.DocValueFormat;
import org.elasticsearch.search.MultiValueMode;
import org.elasticsearch.search.aggregations.support.ValuesSourceType;
import org.elasticsearch.search.sort.BucketedSort;
import org.elasticsearch.search.sort.SortOrder;
import org.elasticsearch.xpack.logsdb.patterntext.PatternTextCompositeValues;
import org.elasticsearch.xpack.logsdb.patterntext.PatternTextFieldType;

public class PatternTextIndexFieldData
implements IndexFieldData<LeafFieldData> {
    private final PatternTextFieldType fieldType;

    PatternTextIndexFieldData(PatternTextFieldType fieldType) {
        this.fieldType = fieldType;
    }

    public String getFieldName() {
        return this.fieldType.name();
    }

    public ValuesSourceType getValuesSourceType() {
        return null;
    }

    public LeafFieldData load(LeafReaderContext context) {
        try {
            return this.loadDirect(context);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    public LeafFieldData loadDirect(LeafReaderContext context) throws IOException {
        LeafReader leafReader = context.reader();
        final PatternTextCompositeValues values = PatternTextCompositeValues.from(leafReader, this.fieldType);
        return new LeafFieldData(){
            final ToScriptFieldFactory<SortedBinaryDocValues> factory = KeywordDocValuesField::new;

            public DocValuesScriptFieldFactory getScriptFieldFactory(String name) {
                return this.factory.getScriptFieldFactory((Object)this.getBytesValues(), name);
            }

            public SortedBinaryDocValues getBytesValues() {
                return new SortedBinaryDocValues(){

                    public boolean advanceExact(int doc) throws IOException {
                        return values.advanceExact(doc);
                    }

                    public int docValueCount() {
                        return 1;
                    }

                    public BytesRef nextValue() throws IOException {
                        return values.binaryValue();
                    }
                };
            }

            public long ramBytesUsed() {
                return 1L;
            }
        };
    }

    public SortField sortField(Object missingValue, MultiValueMode sortMode, IndexFieldData.XFieldComparatorSource.Nested nested, boolean reverse) {
        throw new IllegalArgumentException("not supported for source pattern_text field type");
    }

    public BucketedSort newBucketedSort(BigArrays bigArrays, Object missingValue, MultiValueMode sortMode, IndexFieldData.XFieldComparatorSource.Nested nested, SortOrder sortOrder, DocValueFormat format, int bucketSize, BucketedSort.ExtraData extra) {
        throw new IllegalArgumentException("only supported on numeric fields");
    }

    static class Builder
    implements IndexFieldData.Builder {
        final PatternTextFieldType fieldType;

        Builder(PatternTextFieldType fieldType) {
            this.fieldType = fieldType;
        }

        public PatternTextIndexFieldData build(IndexFieldDataCache cache, CircuitBreakerService breakerService) {
            return new PatternTextIndexFieldData(this.fieldType);
        }
    }
}

