/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.profiling.action;

import java.time.Instant;
import java.util.Map;
import org.elasticsearch.xpack.profiling.action.GetStackTracesRequest;
import org.elasticsearch.xpack.profiling.action.GetStackTracesResponse;
import org.elasticsearch.xpack.profiling.action.StackFrame;
import org.elasticsearch.xpack.profiling.action.StackTrace;
import org.elasticsearch.xpack.profiling.action.TraceEvent;
import org.elasticsearch.xpack.profiling.action.TraceEventID;

class GetStackTracesResponseBuilder {
    private Map<String, StackTrace> stackTraces;
    private Instant start;
    private Instant end;
    private int totalFrames;
    private Map<String, StackFrame> stackFrames;
    private Map<String, String> executables;
    private Map<TraceEventID, TraceEvent> stackTraceEvents;
    private double samplingRate;
    private long totalSamples;
    private long samplingFrequency;
    private Double requestedDuration;
    private final Double awsCostFactor;
    private final Double azureCostFactor;
    private final Double customCO2PerKWH;
    private final Double customDatacenterPUE;
    private final Double customPerCoreWattX86;
    private final Double customPerCoreWattARM64;
    private final Double customCostPerCoreHour;

    public void setStackTraces(Map<String, StackTrace> stackTraces) {
        this.stackTraces = stackTraces;
    }

    public Instant getStart() {
        return this.start;
    }

    public void setStart(Instant start) {
        this.start = start;
    }

    public Instant getEnd() {
        return this.end;
    }

    public void setEnd(Instant end) {
        this.end = end;
    }

    public void setTotalFrames(int totalFrames) {
        this.totalFrames = totalFrames;
    }

    public void addTotalFrames(int numFrames) {
        this.totalFrames += numFrames;
    }

    public void setStackFrames(Map<String, StackFrame> stackFrames) {
        this.stackFrames = stackFrames;
    }

    public void setExecutables(Map<String, String> executables) {
        this.executables = executables;
    }

    public void setStackTraceEvents(Map<TraceEventID, TraceEvent> stackTraceEvents) {
        this.stackTraceEvents = stackTraceEvents;
    }

    public Map<TraceEventID, TraceEvent> getStackTraceEvents() {
        return this.stackTraceEvents;
    }

    public void setSamplingRate(double rate) {
        this.samplingRate = rate;
    }

    public double getSamplingRate() {
        return this.samplingRate;
    }

    public void setSamplingFrequency(long samplingFrequency) {
        this.samplingFrequency = samplingFrequency;
    }

    public long getSamplingFrequency() {
        return this.samplingFrequency;
    }

    public void setRequestedDuration(Double requestedDuration) {
        this.requestedDuration = requestedDuration;
    }

    public double getRequestedDuration() {
        if (this.requestedDuration != null) {
            return this.requestedDuration;
        }
        return this.end.getEpochSecond() - this.start.getEpochSecond();
    }

    public Double getAWSCostFactor() {
        return this.awsCostFactor;
    }

    public Double getAzureCostFactor() {
        return this.azureCostFactor;
    }

    public Double getCustomCO2PerKWH() {
        return this.customCO2PerKWH;
    }

    public Double getCustomDatacenterPUE() {
        return this.customDatacenterPUE;
    }

    public Double getCustomPerCoreWattX86() {
        return this.customPerCoreWattX86;
    }

    public Double getCustomPerCoreWattARM64() {
        return this.customPerCoreWattARM64;
    }

    public Double getCustomCostPerCoreHour() {
        return this.customCostPerCoreHour;
    }

    public void setTotalSamples(long totalSamples) {
        this.totalSamples = totalSamples;
    }

    GetStackTracesResponseBuilder(GetStackTracesRequest request) {
        this.requestedDuration = request.getRequestedDuration();
        this.awsCostFactor = request.getAwsCostFactor();
        this.azureCostFactor = request.getAzureCostFactor();
        this.customCO2PerKWH = request.getCustomCO2PerKWH();
        this.customDatacenterPUE = request.getCustomDatacenterPUE();
        this.customPerCoreWattX86 = request.getCustomPerCoreWattX86();
        this.customPerCoreWattARM64 = request.getCustomPerCoreWattARM64();
        this.customCostPerCoreHour = request.getCustomCostPerCoreHour();
    }

    public GetStackTracesResponse build() {
        if (this.stackTraces != null) {
            for (Map.Entry<TraceEventID, TraceEvent> entry : this.stackTraceEvents.entrySet()) {
                TraceEventID traceEventID = entry.getKey();
                StackTrace stackTrace = this.stackTraces.get(traceEventID.stacktraceID());
                if (stackTrace == null) continue;
                TraceEvent event = entry.getValue();
                if (event.subGroups != null) {
                    stackTrace.subGroups = event.subGroups;
                }
                stackTrace.count += event.count;
                stackTrace.annualCO2Tons += event.annualCO2Tons;
                stackTrace.annualCostsUSD += event.annualCostsUSD;
            }
        }
        return new GetStackTracesResponse(this.stackTraces, this.stackFrames, this.executables, this.stackTraceEvents, this.totalFrames, this.samplingRate, this.totalSamples, this.samplingFrequency);
    }
}

