/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.script.expression;

import org.apache.lucene.search.DoubleValuesSource;
import org.elasticsearch.index.fielddata.IndexFieldData;
import org.elasticsearch.script.expression.CountMethodValueSource;
import org.elasticsearch.script.expression.DateMethodValueSource;
import org.elasticsearch.script.expression.EmptyMemberValueSource;
import org.elasticsearch.script.expression.FieldDataValueSource;
import org.elasticsearch.search.MultiValueMode;

final class DateField {
    static final String VALUE_VARIABLE = "value";
    static final String EMPTY_VARIABLE = "empty";
    static final String LENGTH_VARIABLE = "length";
    static final String GETVALUE_METHOD = "getValue";
    static final String ISEMPTY_METHOD = "isEmpty";
    static final String SIZE_METHOD = "size";
    static final String MINIMUM_METHOD = "min";
    static final String MAXIMUM_METHOD = "max";
    static final String AVERAGE_METHOD = "avg";
    static final String MEDIAN_METHOD = "median";
    static final String SUM_METHOD = "sum";
    static final String COUNT_METHOD = "count";
    static final String GET_YEAR_METHOD = "getYear";
    static final String GET_MONTH_METHOD = "getMonth";
    static final String GET_DAY_OF_MONTH_METHOD = "getDayOfMonth";
    static final String GET_HOUR_OF_DAY_METHOD = "getHourOfDay";
    static final String GET_MINUTES_METHOD = "getMinutes";
    static final String GET_SECONDS_METHOD = "getSeconds";

    private DateField() {
    }

    static DoubleValuesSource getVariable(IndexFieldData<?> fieldData, String fieldName, String variable) {
        return switch (variable) {
            case VALUE_VARIABLE -> new FieldDataValueSource(fieldData, MultiValueMode.MIN);
            case EMPTY_VARIABLE -> new EmptyMemberValueSource(fieldData);
            case LENGTH_VARIABLE -> new CountMethodValueSource(fieldData);
            default -> throw new IllegalArgumentException("Member variable [" + variable + "] does not exist for date field [" + fieldName + "].");
        };
    }

    static DoubleValuesSource getMethod(IndexFieldData<?> fieldData, String fieldName, String method) {
        return switch (method) {
            case GETVALUE_METHOD -> new FieldDataValueSource(fieldData, MultiValueMode.MIN);
            case ISEMPTY_METHOD -> new EmptyMemberValueSource(fieldData);
            case SIZE_METHOD -> new CountMethodValueSource(fieldData);
            case MINIMUM_METHOD -> new FieldDataValueSource(fieldData, MultiValueMode.MIN);
            case MAXIMUM_METHOD -> new FieldDataValueSource(fieldData, MultiValueMode.MAX);
            case AVERAGE_METHOD -> new FieldDataValueSource(fieldData, MultiValueMode.AVG);
            case MEDIAN_METHOD -> new FieldDataValueSource(fieldData, MultiValueMode.MEDIAN);
            case SUM_METHOD -> new FieldDataValueSource(fieldData, MultiValueMode.SUM);
            case COUNT_METHOD -> new CountMethodValueSource(fieldData);
            case GET_YEAR_METHOD -> new DateMethodValueSource(fieldData, MultiValueMode.MIN, method, 1);
            case GET_MONTH_METHOD -> new DateMethodValueSource(fieldData, MultiValueMode.MIN, method, 2);
            case GET_DAY_OF_MONTH_METHOD -> new DateMethodValueSource(fieldData, MultiValueMode.MIN, method, 5);
            case GET_HOUR_OF_DAY_METHOD -> new DateMethodValueSource(fieldData, MultiValueMode.MIN, method, 11);
            case GET_MINUTES_METHOD -> new DateMethodValueSource(fieldData, MultiValueMode.MIN, method, 12);
            case GET_SECONDS_METHOD -> new DateMethodValueSource(fieldData, MultiValueMode.MIN, method, 13);
            default -> throw new IllegalArgumentException("Member method [" + method + "] does not exist for date field [" + fieldName + "].");
        };
    }
}

