/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.esql.enrich;

import java.io.IOException;
import java.util.List;
import java.util.Objects;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.common.io.stream.NamedWriteableRegistry;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.compute.data.Block;
import org.elasticsearch.compute.data.Page;
import org.elasticsearch.compute.operator.AsyncOperator;
import org.elasticsearch.compute.operator.DriverContext;
import org.elasticsearch.compute.operator.Operator;
import org.elasticsearch.core.CheckedFunction;
import org.elasticsearch.tasks.CancellableTask;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.XContentBuilder;
import org.elasticsearch.xpack.esql.core.expression.NamedExpression;
import org.elasticsearch.xpack.esql.core.tree.Source;
import org.elasticsearch.xpack.esql.core.type.DataType;
import org.elasticsearch.xpack.esql.enrich.EnrichLookupService;

public final class EnrichLookupOperator
extends AsyncOperator<Page> {
    private final EnrichLookupService enrichLookupService;
    private final String sessionId;
    private final CancellableTask parentTask;
    private final int inputChannel;
    private final DataType inputDataType;
    private final String enrichIndex;
    private final String matchType;
    private final String matchField;
    private final List<NamedExpression> enrichFields;
    private final Source source;
    private long totalTerms = 0L;

    public EnrichLookupOperator(String sessionId, DriverContext driverContext, CancellableTask parentTask, int maxOutstandingRequests, int inputChannel, EnrichLookupService enrichLookupService, DataType inputDataType, String enrichIndex, String matchType, String matchField, List<NamedExpression> enrichFields, Source source) {
        super(driverContext, enrichLookupService.getThreadContext(), maxOutstandingRequests);
        this.sessionId = sessionId;
        this.parentTask = parentTask;
        this.inputChannel = inputChannel;
        this.enrichLookupService = enrichLookupService;
        this.inputDataType = inputDataType;
        this.enrichIndex = enrichIndex;
        this.matchType = matchType;
        this.matchField = matchField;
        this.enrichFields = enrichFields;
        this.source = source;
    }

    protected void performAsync(Page inputPage, ActionListener<Page> listener) {
        Block inputBlock = inputPage.getBlock(this.inputChannel);
        this.totalTerms += (long)inputBlock.getTotalValueCount();
        EnrichLookupService.Request request = new EnrichLookupService.Request(this.sessionId, this.enrichIndex, this.inputDataType, this.matchType, this.matchField, new Page(new Block[]{inputBlock}), this.enrichFields, this.source);
        CheckedFunction handleResponse = pages -> {
            if (pages.size() != 1) {
                throw new UnsupportedOperationException("ENRICH should only return a single page");
            }
            return inputPage.appendPage((Page)pages.getFirst());
        };
        this.enrichLookupService.lookupAsync(request, this.parentTask, (ActionListener<List<Page>>)listener.map(handleResponse));
    }

    public Page getOutput() {
        return (Page)this.fetchFromBuffer();
    }

    protected void releaseFetchedOnAnyThread(Page page) {
        EnrichLookupOperator.releasePageOnAnyThread((Page)page);
    }

    public String toString() {
        return "EnrichOperator[index=" + this.enrichIndex + " input_type=" + String.valueOf(this.inputDataType) + " match_field=" + this.matchField + " enrich_fields=" + String.valueOf(this.enrichFields) + " inputChannel=" + this.inputChannel + "]";
    }

    protected void doClose() {
    }

    protected Operator.Status status(long receivedPages, long completedPages, long processNanos) {
        return new Status(receivedPages, completedPages, processNanos, this.totalTerms);
    }

    public static class Status
    extends AsyncOperator.Status {
        public static final NamedWriteableRegistry.Entry ENTRY = new NamedWriteableRegistry.Entry(Operator.Status.class, "enrich", Status::new);
        final long totalTerms;

        Status(long receivedPages, long completedPages, long processNanos, long totalTerms) {
            super(receivedPages, completedPages, processNanos);
            this.totalTerms = totalTerms;
        }

        Status(StreamInput in) throws IOException {
            super(in);
            this.totalTerms = in.readVLong();
        }

        public void writeTo(StreamOutput out) throws IOException {
            super.writeTo(out);
            out.writeVLong(this.totalTerms);
        }

        public String getWriteableName() {
            return Status.ENTRY.name;
        }

        public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
            builder.startObject();
            this.innerToXContent(builder);
            builder.field("total_terms", this.totalTerms);
            return builder.endObject();
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || ((Object)((Object)this)).getClass() != o.getClass() || !super.equals(o)) {
                return false;
            }
            Status status = (Status)((Object)o);
            return this.totalTerms == status.totalTerms;
        }

        public int hashCode() {
            return Objects.hash(super.hashCode(), this.totalTerms);
        }
    }

    public record Factory(String sessionId, CancellableTask parentTask, int maxOutstandingRequests, int inputChannel, EnrichLookupService enrichLookupService, DataType inputDataType, String enrichIndex, String matchType, String matchField, List<NamedExpression> enrichFields, Source source) implements Operator.OperatorFactory
    {
        public String describe() {
            return "EnrichOperator[index=" + this.enrichIndex + " match_field=" + this.matchField + " enrich_fields=" + String.valueOf(this.enrichFields) + " inputChannel=" + this.inputChannel + "]";
        }

        public Operator get(DriverContext driverContext) {
            return new EnrichLookupOperator(this.sessionId, driverContext, this.parentTask, this.maxOutstandingRequests, this.inputChannel, this.enrichLookupService, this.inputDataType, this.enrichIndex, this.matchType, this.matchField, this.enrichFields, this.source);
        }
    }
}

