/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.tasks;

import java.util.Map;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.support.SubscribableListener;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.tasks.Task;
import org.elasticsearch.tasks.TaskCancelledException;
import org.elasticsearch.tasks.TaskId;

public class CancellableTask
extends Task {
    private volatile String reason;
    private volatile boolean isCancelled;
    private final SubscribableListener<Void> listeners = new SubscribableListener();

    public CancellableTask(long id, String type, String action, String description, TaskId parentTaskId, Map<String, String> headers) {
        super(id, type, action, description, parentTaskId, headers);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void cancel(String reason) {
        assert (reason != null);
        CancellableTask cancellableTask = this;
        synchronized (cancellableTask) {
            if (this.isCancelled) {
                return;
            }
            this.isCancelled = true;
            this.reason = reason;
        }
        this.listeners.onResponse(null);
        this.onCancelled();
    }

    public boolean shouldCancelChildrenOnCancellation() {
        return true;
    }

    public final boolean isCancelled() {
        return this.isCancelled;
    }

    @Nullable
    public final String getReasonCancelled() {
        return this.reason;
    }

    public final void addListener(CancellationListener listener) {
        this.listeners.addListener(new CancellationListenerAdapter(listener));
    }

    protected void onCancelled() {
    }

    public final void ensureNotCancelled() {
        if (this.isCancelled()) {
            CancellableTask cancellableTask = this;
            synchronized (cancellableTask) {
                throw this.getTaskCancelledException();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final <T> boolean notifyIfCancelled(ActionListener<T> listener) {
        TaskCancelledException taskCancelledException;
        if (!this.isCancelled) {
            return false;
        }
        CancellableTask cancellableTask = this;
        synchronized (cancellableTask) {
            taskCancelledException = this.getTaskCancelledException();
        }
        listener.onFailure(taskCancelledException);
        return true;
    }

    @Override
    public String toString() {
        return "CancellableTask{" + super.toString() + ", reason='" + this.reason + "', isCancelled=" + this.isCancelled + "}";
    }

    private TaskCancelledException getTaskCancelledException() {
        assert (Thread.holdsLock(this));
        assert (this.isCancelled);
        assert (this.reason != null);
        return new TaskCancelledException("task cancelled [" + this.reason + "]");
    }

    private record CancellationListenerAdapter(CancellationListener cancellationListener) implements ActionListener<Void>
    {
        @Override
        public void onResponse(Void unused) {
            this.cancellationListener.onCancelled();
        }

        @Override
        public void onFailure(Exception e) {
            assert (false) : e;
        }
    }

    public static interface CancellationListener {
        public void onCancelled();
    }
}

