/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.rest.action.cat;

import java.util.HashMap;
import java.util.List;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.admin.cluster.node.stats.NodeStats;
import org.elasticsearch.action.admin.cluster.node.stats.NodesStatsRequest;
import org.elasticsearch.action.admin.cluster.node.stats.NodesStatsRequestParameters;
import org.elasticsearch.action.admin.cluster.node.stats.NodesStatsResponse;
import org.elasticsearch.action.admin.cluster.state.ClusterStateRequest;
import org.elasticsearch.action.admin.cluster.state.ClusterStateResponse;
import org.elasticsearch.action.admin.indices.stats.CommonStatsFlags;
import org.elasticsearch.client.internal.node.NodeClient;
import org.elasticsearch.cluster.node.DiscoveryNode;
import org.elasticsearch.cluster.routing.ShardRouting;
import org.elasticsearch.cluster.routing.allocation.NodeAllocationStats;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.Table;
import org.elasticsearch.common.unit.ByteSizeValue;
import org.elasticsearch.rest.BaseRestHandler;
import org.elasticsearch.rest.RestHandler;
import org.elasticsearch.rest.RestRequest;
import org.elasticsearch.rest.RestResponse;
import org.elasticsearch.rest.RestUtils;
import org.elasticsearch.rest.Scope;
import org.elasticsearch.rest.ServerlessScope;
import org.elasticsearch.rest.action.RestActionListener;
import org.elasticsearch.rest.action.RestResponseListener;
import org.elasticsearch.rest.action.cat.AbstractCatAction;
import org.elasticsearch.rest.action.cat.RestTable;

@ServerlessScope(value=Scope.INTERNAL)
public class RestAllocationAction
extends AbstractCatAction {
    private static final String UNASSIGNED = "UNASSIGNED";

    @Override
    public List<RestHandler.Route> routes() {
        return List.of(new RestHandler.Route(RestRequest.Method.GET, "/_cat/allocation"), new RestHandler.Route(RestRequest.Method.GET, "/_cat/allocation/{nodes}"));
    }

    @Override
    public String getName() {
        return "cat_allocation_action";
    }

    @Override
    protected void documentation(StringBuilder sb) {
        sb.append("/_cat/allocation\n");
    }

    @Override
    public BaseRestHandler.RestChannelConsumer doCatRequest(final RestRequest request, final NodeClient client) {
        final String[] nodes = Strings.splitStringByCommaToArray(request.param("nodes", "data:true"));
        ClusterStateRequest clusterStateRequest = new ClusterStateRequest(RestUtils.getMasterNodeTimeout(request));
        clusterStateRequest.clear().routingTable(true);
        RestUtils.consumeDeprecatedLocalParameter(request);
        return channel -> client.admin().cluster().state(clusterStateRequest, (ActionListener<ClusterStateResponse>)new RestActionListener<ClusterStateResponse>(channel){

            @Override
            public void processResponse(final ClusterStateResponse state) {
                NodesStatsRequest statsRequest = new NodesStatsRequest(nodes);
                statsRequest.setIncludeShardsStats(false);
                statsRequest.clear().addMetric(NodesStatsRequestParameters.Metric.FS).addMetric(NodesStatsRequestParameters.Metric.ALLOCATIONS).indices(new CommonStatsFlags(CommonStatsFlags.Flag.Store));
                client.admin().cluster().nodesStats(statsRequest, (ActionListener<NodesStatsResponse>)new RestResponseListener<NodesStatsResponse>(this.channel){

                    @Override
                    public RestResponse buildResponse(NodesStatsResponse stats) throws Exception {
                        Table tab = RestAllocationAction.this.buildTable(request, state, stats);
                        return RestTable.buildResponse(tab, this.channel);
                    }
                });
            }
        });
    }

    @Override
    protected Table getTableWithHeader(RestRequest request) {
        Table table = new Table();
        table.startHeaders();
        table.addCell("shards", "alias:s;text-align:right;desc:number of shards on node");
        table.addCell("shards.undesired", "text-align:right;desc:number of shards that are scheduled to be moved elsewhere in the cluster");
        table.addCell("write_load.forecast", "alias:wlf,writeLoadForecast;text-align:right;desc:sum of index write load forecasts");
        table.addCell("disk.indices.forecast", "alias:dif,diskIndicesForecast;text-align:right;desc:sum of shard size forecasts");
        table.addCell("disk.indices", "alias:di,diskIndices;text-align:right;desc:disk used by ES indices");
        table.addCell("disk.used", "alias:du,diskUsed;text-align:right;desc:disk used (total, not just ES)");
        table.addCell("disk.avail", "alias:da,diskAvail;text-align:right;desc:disk available");
        table.addCell("disk.total", "alias:dt,diskTotal;text-align:right;desc:total capacity of all volumes");
        table.addCell("disk.percent", "alias:dp,diskPercent;text-align:right;desc:percent disk used");
        table.addCell("host", "alias:h;desc:host of node");
        table.addCell("ip", "desc:ip of node");
        table.addCell("node", "alias:n;desc:name of node");
        table.addCell("node.role", "alias:r,role,nodeRole;desc:node roles");
        table.endHeaders();
        return table;
    }

    private Table buildTable(RestRequest request, ClusterStateResponse state, NodesStatsResponse stats) {
        HashMap<String, Integer> shardCounts = new HashMap<String, Integer>();
        for (ShardRouting shard : state.getState().routingTable().allShardsIterator()) {
            String nodeId = shard.assignedToNode() ? shard.currentNodeId() : UNASSIGNED;
            shardCounts.merge(nodeId, 1, Integer::sum);
        }
        Table table = this.getTableWithHeader(request);
        for (NodeStats nodeStats : stats.getNodes()) {
            DiscoveryNode node = nodeStats.getNode();
            ByteSizeValue total = nodeStats.getFs().getTotal().getTotal();
            ByteSizeValue avail = nodeStats.getFs().getTotal().getAvailable();
            long used = 0L;
            short diskPercent = -1;
            if (total.getBytes() > 0L && (used = total.getBytes() - avail.getBytes()) >= 0L && avail.getBytes() >= 0L) {
                diskPercent = (short)(used * 100L / (used + avail.getBytes()));
            }
            NodeAllocationStats nodeAllocationStats = nodeStats.getNodeAllocationStats();
            table.startRow();
            table.addCell(shardCounts.getOrDefault(node.getId(), 0));
            table.addCell(nodeAllocationStats != null ? Integer.valueOf(nodeAllocationStats.undesiredShards()) : null);
            table.addCell(nodeAllocationStats != null ? Double.valueOf(nodeAllocationStats.forecastedIngestLoad()) : null);
            table.addCell(nodeAllocationStats != null ? ByteSizeValue.ofBytes(nodeAllocationStats.forecastedDiskUsage()) : null);
            table.addCell(nodeStats.getIndices().getStore().size());
            table.addCell(used < 0L ? null : ByteSizeValue.ofBytes(used));
            table.addCell(avail.getBytes() < 0L ? null : avail);
            table.addCell(total.getBytes() < 0L ? null : total);
            table.addCell(diskPercent < 0 ? null : Short.valueOf(diskPercent));
            table.addCell(node.getHostName());
            table.addCell(node.getHostAddress());
            table.addCell(node.getName());
            table.addCell(node.getRoleAbbreviationString());
            table.endRow();
        }
        if (shardCounts.containsKey(UNASSIGNED)) {
            table.startRow();
            table.addCell(shardCounts.get(UNASSIGNED));
            table.addCell(null);
            table.addCell(null);
            table.addCell(null);
            table.addCell(null);
            table.addCell(null);
            table.addCell(null);
            table.addCell(null);
            table.addCell(null);
            table.addCell(null);
            table.addCell(null);
            table.addCell(UNASSIGNED);
            table.addCell(null);
            table.endRow();
        }
        return table;
    }
}

